/* $Id: StringUtils.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.util;

public class StringUtils {
	/**
	 * 文字列中の指定された部分(文字列)を検索し、指定された文字列で置き換える<BR>
	 * @param target 変換対象文字列（全体）
	 * @param src 置き換え対象文字列
	 * @param dst 置き換え文字列
	 * @return 変換後文字列
	 */
	public static final String replaceString(String target, String src, String dst) {

		if(target == null)
			return "";

		//	変換対象文字列そのものを変換してしまわないように新たなオブジェクトを生成する
		String work = new String(target);
		
		int i = -1;
		while((i = work.indexOf(src, i)) != -1) {
			String w = new String();
			w = work.substring(0, i);
			w = w + dst;
			w = w + work.substring(i + src.length());
			work = w;
			i += dst.length();
		}

		return(work);
	}

}
