package smart_gs.swingui.toolbar.action;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JOptionPane;
import javax.swing.JFrame;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.State;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.image_search.GSSearchEngine;
import smart_gs.logical.LineSegment;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.LineSegEditorMoveAndResizeFrame;

public class LineSegEditorMoveAndResizeActionListener implements ActionListener{
	
	private LineSegEditor editor;
	private Spread spread;
	
	

	public LineSegEditorMoveAndResizeActionListener(LineSegEditor parent){
		this.editor = parent;
		
	}
	
	public void actionPerformed(ActionEvent e){
		this.spread = this.editor.getSpread();
		if(ImageLabel.isLineShown()==false){
			JOptionPane.showMessageDialog(new JFrame(), "Please show Lines","error",  JOptionPane.INFORMATION_MESSAGE);
			return;
		}
		
		LineSegEditorMoveAndResizeFrame frame = new LineSegEditorMoveAndResizeFrame(this.editor);
		this.editor.setLineSegEditorImageLabelCursor(new Cursor(Cursor.DEFAULT_CURSOR));
		frame.setVisible(true);
		return;
	}
		
	
}
