package smart_gs.swingui.toolbar.action;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JOptionPane;

import smart_gs.drawing_tool.drawing_mode.LineSegEditorDeleterMode;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorDivideMode;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.util.GSLog;

public class LineSegEditorDeleteActionListener implements ActionListener {
	LineSegEditor editor;
	StringBuffer selectedIndexesInString;
	int type = 0;
	
	public LineSegEditorDeleteActionListener(LineSegEditor editor, int type) {
		this.editor = editor;
		this.type = type;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		ArrayList<Integer> selected = this.editor.getSelectedLineIndexes();
		selectedIndexesInString = new StringBuffer("");
		
		int length = selected.size();
		
		if (length == 0) {
			this.editor.pushUndoStack();
			LineSegEditorDeleterMode mode = new LineSegEditorDeleterMode(editor);
			this.editor.setMode(mode);
			return;
		} else if (length == 1) {
			selectedIndexesInString.append(selected.get(0));
//		} else if (length == 2) {
//			selectedIndexesInString.append(selected.get(0));
//			selectedIndexesInString.append(" ");
//			selectedIndexesInString.append(selected.get(1));
		} else {
			// HERE HERE
			int start = selected.get(0);
			int end = start;

			for (int i=1; i<length - 1; i++) {
				int next = selected.get(i);
				if (next > end + 1) {
					if (start == end) {
						selectedIndexesInString.append(start);
					}
					else {
						selectedIndexesInString.append(start);
						selectedIndexesInString.append("-");
						selectedIndexesInString.append(end);
					}
					selectedIndexesInString.append(" ");
					start = next;
					end = next;
				} else if (next == end + 1) {
					end = next;
				} else {
					GSLog.getInstance().error("Bad selected lines in LineSegEditorDeleteActionListener");
				}
			}
			// process the last line index
			int last = selected.get(length - 1);
			if (last == end + 1) {
				selectedIndexesInString.append(start);
				selectedIndexesInString.append("-");
				selectedIndexesInString.append(last);
			}
			else {
				if (start == end) {
					selectedIndexesInString.append(start);
					selectedIndexesInString.append(" ");
					selectedIndexesInString.append(last);
				}
				else {
					selectedIndexesInString.append(start);
					selectedIndexesInString.append("-");
					selectedIndexesInString.append(end);
					selectedIndexesInString.append(" ");
					selectedIndexesInString.append(last);
				}
			}
		}
		String input = null;
		if (this.type == 0)
			input = JOptionPane.showInputDialog("Delete these lines:", (selectedIndexesInString.length() != 0)?selectedIndexesInString:"");
		else if (this.type == 1)
			input = JOptionPane.showInputDialog("Delete these and narrower lines:", (selectedIndexesInString.length() != 0)?selectedIndexesInString:"");
		if(input == null){
			return;
		}

		LineSegEditorDeleteResultLinesMaker mkr = new LineSegEditorDeleteResultLinesMaker(input,this.editor.getLinesForEdit(),this.type, this.editor);
		mkr.process();
		if (mkr.isCanceled()) return;
		this.editor.pushUndoStack();
		this.editor.setLinesForEdit(mkr.getLines());
		this.editor.rewriteLineSegIndexes();
		this.editor.setLineSegEditorImageLabelCursor(new Cursor(Cursor.DEFAULT_CURSOR));
		this.editor.invalidate();
		this.editor.validate();
		this.editor.repaint();
	}
}

