package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;

import javax.swing.JOptionPane;

import org.apache.commons.io.FileUtils;

import smart_gs.logical.LineSegment;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.DSCFileMaker;
import smart_gs.util.GSLog;

public class DeleteSegfoFileAction implements ActionListener {
	private LineSegEditor editor;
	private Spread spread;
	public DeleteSegfoFileAction(LineSegEditor parent) {
		this.editor = parent;
	}

	public void actionPerformed(ActionEvent e) {
		this.spread = this.editor.getSpread();
		
		String folderPath = Spread.DSC_FOLDER_PATH+spread.getSpreadDirParent().getPath();
		String filename = spread.getFileNameWithoutExtension();
		File file = new File(folderPath + filename + ".segfo");
		if (! file.exists()) {
			GSLog.getInstance().warnWithWindow(String.format("File%n  " + filename + ".segfo" + "%ndoes not exist"));
			return;
		}
		
		if (JOptionPane.showConfirmDialog(null,"Deletion of Line Segment Fiile cannot be undo. Really delete it?","",JOptionPane.YES_NO_OPTION) != 0) return ;

		try {
			FileUtils.forceDelete(file);
		} catch (IOException e1) {
			e1.printStackTrace();
		}

		if (!file.exists()){
			JOptionPane.showMessageDialog(null,filename + ".segfo deleted");
		} else {
			JOptionPane.showMessageDialog(null,"failed to delete " + filename + ".segfo");
		}
		WorkspaceWindow.getInstance().updateAndPaintSpreadTree();
	}
}