package smart_gs.swingui.toolbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import smart_gs.smleditor.swingui.GSEditor;

public class GSEditorTypeAndModeButtonActionListener implements ActionListener {
	private GSEditor editor;

	public GSEditorTypeAndModeButtonActionListener(GSEditor editor) {
		this.editor = editor;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		int type = this.editor.getEditorType();

		if (type == GSEditor.COMPACT) {
			this.editor.setEditorType(GSEditor.FULL);
			this.editor.getUtilityToolBar().setGSEditorTypeAndDisplayModeIconToCompactEditorIcon();
			this.editor.validate();
			this.editor.repaint();
		} else if (type == GSEditor.FULL){
			if ((e.getModifiers() & ActionEvent.ALT_MASK) == ActionEvent.ALT_MASK) {
				this.editor.setEditorType(GSEditor.FULL);
				this.editor.stepDisplayMode();
				this.editor.getUtilityToolBar().setGSEditorTypeAndDisplayModeIconToCompactEditorIcon();
				this.editor.updateGUI();
			} else {
				this.editor.setEditorType(GSEditor.COMPACT);
				this.editor.getUtilityToolBar().setGSEditorTypeAndDisplayModeIconToFullEditorIcon();
				this.editor.validate();
				this.editor.repaint();
			}
		}
	}
}
