/* $Id: SpreadFilter.java 222 2011-06-12 16:44:45Z shayashi $ */
package smart_gs.spread_selection;

import java.util.List;
import java.util.ArrayList;

import smart_gs.logical.Spread;
import smart_gs.logical.SpreadTree;

public class SpreadFilter {

	/**
	 * フィルタリング対象のリスト
	 */
	private List<Spread> allSpreads;
	/**
	 * フィルタリング後のリスト
	 */
	private List<Spread> filterdSpreads;
	
	public SpreadFilter(){
		this(SpreadTree.getInstance().getSpreads());
	}
	public SpreadFilter(List<Spread> spreads){
		this.allSpreads = spreads;
	}
	/**
	 *　指定したページ(複数ページ）のスプレッドをのリストを得る。 
	 * @param beginIndex
	 * @param endIndex
	 */
	public void filter(int beginIndex, int endIndex) {
		/**
		 * テーブルを使うようになると、userIndexの取得処理が必要
		 */
//		System.out.println(beginIndex+"-"+endIndex);
		List<Spread> hitSpreads = new ArrayList<Spread>();
		for (int i = 0; i < allSpreads.size(); i++) {
			if (beginIndex <= allSpreads.get(i).getPageIndex() && allSpreads.get(i).getPageIndex() <= endIndex) {
				hitSpreads.add(allSpreads.get(i));
			} 
		}
		this.filterdSpreads = hitSpreads;
	}
	/**
	 * 指定したページ（単一ページ）を含むスプレッドのリストを得る。
	 * @param index
	 */
	public void filter(int index){
		List<Spread> hitSpreads = new ArrayList<Spread>();
		for (int i = 0; i < allSpreads.size(); i++) {
			if (index == allSpreads.get(i).getPageIndex()) {
				hitSpreads.add(allSpreads.get(i));
			} 
		}
		this.filterdSpreads = hitSpreads;
	}
	public List<Spread> getFilterdSpreads(){
		return this.filterdSpreads;
	}
}
