/* $Id: LoadTagNameParser.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.smleditor.swingui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LoadTagNameParser {
	/**
	 * タグ正規表現
	 */
	private static Pattern tagPattern = Pattern.compile("(<([^ >]+)([^>]*)>)([^<]*)");
	/**
	 * マッチャー
	 */
	private Matcher matcher;
	/**
	 * タグ名
	 */
	protected ArrayList list = new ArrayList();
	/**
	 * コンストラクタです。
	 * 
	 * @param src
	 *            HTMLソース
	 */
	public LoadTagNameParser(String src) {
		matcher = tagPattern.matcher(src);
	}

	/**
	 * 次のHTMLタグがあるかどうかを検査します。
	 * 
	 * @return 存在する場合はtrue
	 */
	public ArrayList parser() {
		while (matcher.find()) {
			String tagName = matcher.group(2);
			String tagAttribute = matcher.group(3);
			String tagText = matcher.group(4) ;
			if(tagName.equals("a")){
				if(!tagAttribute.equals("")){
					StringTokenizer stsp = new StringTokenizer(tagAttribute, " ");
			        while (stsp.hasMoreTokens()) {
			        	String tonkenspStr =  stsp.nextToken();
			        	if(!tonkenspStr.trim().equals("")){
							StringTokenizer st = new StringTokenizer(tonkenspStr, "=");
							boolean isValue = false;
					        while (st.hasMoreTokens()) {
				        		String tonkenStr =  st.nextToken();
					        	if(isValue){
					        		String value = tonkenStr;
					        		if(value.startsWith("\"")){
					        			value = value.substring(1);
					        		}
					        		if(value.endsWith("\"")){
					        			value = value.substring(0,value.length() -1);
					        		}
					        		list.add(value);
					        		break;
					        	}else{
					        		if(tonkenStr.toLowerCase().trim().equals("id")){
					        			isValue = true;;
					        		}
					        	}
					        }
			        	}
			        }
				}
			}
		}
		return list;
	}
}
