/* $Id: ToolBarPanel.java 640 2013-01-29 14:34:28Z shayashi $ */
package smart_gs.smleditor.swingui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

import smart_gs.swingui.toolbar.GSEditorToolBar;
import smart_gs.swingui.toolbar.HistoryToolBar;
import sml_editor.logical.LineDirection;
@SuppressWarnings("serial")
public class LineSegEditorToolBarPanel extends JPanel{
	
	private GSEditorToolBar editorToolBar;
	private HistoryToolBar historyToolBar;
	private LineSegEditorToolBar linesegToolBar;
	private static JLabel horizontalLineTextIcon = null;
	private static JLabel verticalLineTextIcon = null;
	private static JLabel undefinedLineTextIcon = null;
	private JLabel lineTextIcon = null;


	public LineSegEditorToolBarPanel(LineSegEditor parent){
//		super(new GridLayout(1,1));
		super(new BorderLayout());
		
		if (horizontalLineTextIcon == null) {
			try {
				horizontalLineTextIcon = new JLabel( new ImageIcon(ImageIO.read(new File("./icons/horizontal.png"))));
			} catch (IOException e) {
				System.out.println("Failed to read horizontal.png");
			}
		}
		
		if (verticalLineTextIcon == null) {
			try {
				verticalLineTextIcon = new JLabel( new ImageIcon(ImageIO.read(new File("./icons/vertical.png"))));
			} catch (IOException e) {
				System.out.println("Failed to read vertical.png");
			}
		}
		
		if (undefinedLineTextIcon == null) {
			try {
				undefinedLineTextIcon = new JLabel( new ImageIcon(ImageIO.read(new File("./icons/undefined.png"))));
			} catch (IOException e) {
				System.out.println("Failed to read undefined.png");
			}
		}
		
		
		lineTextIcon = undefinedLineTextIcon;
		this.add(lineTextIcon, BorderLayout.WEST);
		
		JPanel panel1 = new JPanel(new FlowLayout(FlowLayout.LEFT));
		this.add(panel1,BorderLayout.CENTER);
		this.validate();
		
//		moveTreeToolBar = new LineSegEditorMoveTreeToolBar(parent);
//		panel1.add(moveTreeToolBar);
		
		linesegToolBar = new LineSegEditorToolBar(parent);
		panel1.add(linesegToolBar);
		
		panel1.validate();

		this.add(panel1);
		this.validate();
	}
	
	public void setLineDirectionIcon(LineDirection direction) {
		if (lineTextIcon != null) this.remove(lineTextIcon);
		if (direction == LineDirection.HORIZONTAL) {
			lineTextIcon = horizontalLineTextIcon;
		}
		
		if (direction.equals(LineDirection.VERTICAL)) {
			lineTextIcon = verticalLineTextIcon;

		} 
		
		if (direction.equals(LineDirection.UNDEFINED)){
			lineTextIcon = undefinedLineTextIcon;
		}
		
	    this.add(lineTextIcon,BorderLayout.WEST);
	    this.validate();
	}


	public GSEditorToolBar getGSEditorToolBar(){
		return editorToolBar;
	}
	public HistoryToolBar getHistoryToolBar(){
		return historyToolBar;
	}

	public LineSegEditorToolBar getToolBar() {
		return linesegToolBar; 
	}
}
