/* $Id: IDATPanel.java 701 2013-05-13 02:06:09Z ohura $ */
package smart_gs.smleditor.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import smart_gs.logical.IDAT;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import sml_editor.swingui.EditorTextPane;

@SuppressWarnings("serial")
public class IDATPanel extends JPanel{
	
	protected IDAT iDAT;
	private GSEditorTextPane textPane;
	private GSEditorToolBar editorToolBar;

	public IDATPanel(){
		super();
	}
	
	public IDATPanel(GSEditorFrame parent,IDAT iDAT){
		this.iDAT = iDAT;
		String source = this.iDAT.getSource();

		source = getInitSource(source);
		ArrayList taglist = new ArrayList();
		try{
			LoadTagNameParser loadTagNameParser = new LoadTagNameParser(source);
			taglist = loadTagNameParser.parser();
		}catch(Exception e){
			e.printStackTrace();
		}

		this.textPane = new GSEditorTextPane(iDAT,source);
		for(int i=0;i<taglist.size();i++){
			this.textPane.getGSHTMLEditorTextPane().addTagList((String)taglist.get(i));
		}
		new GSEditorPanel(parent,this.textPane);
		this.setLayout(new BorderLayout());
		this.editorToolBar = new GSEditorToolBar(this.textPane);
		this.add(editorToolBar, BorderLayout.NORTH);		
		this.add(textPane,BorderLayout.CENTER);
	}
	public void save(){
		this.textPane.save();
	}
	
	public void load(){
		this.textPane.load();
	}
	public void emphasize(String id) {
		this.textPane.setCaretPosition(this.textPane.getCaretPosition()+1);
		this.textPane.emphasize(id);
	}

	public void emphasize(int start, int length) {
		this.textPane.setCaretPosition(this.textPane.getCaretPosition()+1);
		this.textPane.emphasize(start,length);
	}
	
	public void updateText() {
		this.textPane.getGSHTMLEditorTextPane().updateText();
	}

	public GSEditorTextPane getTextPane(){
		return this.textPane;
	}

	public void jumpLinkToText(int position){
		FocusEvent aEvent = new FocusEvent(textPane.getGSHTMLEditorTextPane(), FocusEvent.FOCUS_GAINED);
		Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(aEvent);
		if(position == 0){
			this.textPane.setCaretPosition(1);
			return;
		}
		String text = textPane.getPainText();
		if(text != null){
			if(!text.equals("")){
				int jumpposition = 1;
				int jumpcounter = 0;
				for(int i=0;i<text.length();i++){
					if(position == jumpcounter){
						this.textPane.setCaretPosition(jumpposition);
						return;
					}
					if(text.charAt(i) == '\n'){
						jumpcounter++;
						jumpposition++;
					}else if(text.charAt(i) == '\r'){
					}else{
						jumpposition++;
					}
				}
			}
		}
	}
	
	public void focus(){
		FocusEvent aEvent = new FocusEvent(textPane.getGSHTMLEditorTextPane(), FocusEvent.FOCUS_GAINED);
		Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(aEvent);
	}
	
	public IDAT getIDAT(){
		return iDAT;
	}
	protected String getInitSource(String sourceStr){
		String source = sourceStr;
		boolean load = false;

		if(source == null){
			return source;
		}
		try{
			if(source.startsWith("<xml><html>")){
				if(source.endsWith("</html></xml>")){
					source = source.substring("<xml><html>".length(),source.length() - "<body></html>".length());
					load =  true;
				}
			}
		}catch(Exception e){
			e.printStackTrace();
		}
		if(!load){
			source = null;
		}
		return source;
		
	}
	public boolean containsTextSegmentOfId(String id) {
//		TODO
		return false;
	}

	public void setEditorTextPane(EditorTextPane textPane) {
		this.editorToolBar.setTextPane(textPane);
	}

	public GSEditorToolBar getGSEditorToolBar() {
		return editorToolBar;
	}
	
	public void resetCaretPosition() {
		this.textPane.setCaretPosition(0);
	}

	
}
