/* $Id: GSEditorPopupMenu.java 1096 2016-04-20 13:44:12Z shayashi $ */
package smart_gs.smleditor.swingui;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import smart_gs.connection.ConnectionCreator;
import smart_gs.drawing_tool.action.AddToBasketAction;
import smart_gs.drawing_tool.action.JumpWebPageAction;
import smart_gs.drawing_tool.action.RemoveExternalLinkAction;
import smart_gs.drawing_tool.action.RemoveMarkupAction;
import smart_gs.drawing_tool.action.SetExternalLinkAction;
import smart_gs.drawing_tool.action.SetLinkSourceAction;
import smart_gs.drawing_tool.action.SetLinkTargetAction;
import smart_gs.drawing_tool.action.ShowInRWAction;
import smart_gs.drawing_tool.action.cancelConnectionCreationAction;
import smart_gs.logical.GSResource;
import smart_gs.logical.ResourceBasket;
import smart_gs.logical.TextSegment;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.swingui.toolbar.action.ShowLocalViewAction;
import sml_editor.swingui.EditorTextPane;
 
@SuppressWarnings("serial")
public class GSEditorPopupMenu extends JPopupMenu{
	
	public GSEditorPopupMenu(final TextSegment segment,final EditorTextPane textPane,final Point point,boolean href) {
//		if(segment.getTagName().equals("anchor")) {
//			JMenuItem jumpToAnchorRegion = new JMenuItem("Jump to Linked Paragraph");
//			jumpToAnchorRegion.addActionListener(new AnchorJumpAction((AnchorTextSegment)segment));
//			this.add(jumpToAnchorRegion);
//		}

		boolean externallink = false;
		if(textPane.getSelectURLStr(point)!=null){
			externallink = true;
		}

		JMenuItem localView = new JMenuItem("Show Connections");
		if(!GS_RWRepository.getInstance().hasLink(segment) || ConnectionCreator.isMakingLink()){
			localView.setEnabled(false);
		}
		localView.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				new ShowLocalViewAction(segment).execute();
			}
		});
		this.add(localView);
		
		this.addSeparator();
		
		JMenuItem setSource = new JMenuItem("Set Link Source");
		if((!ConnectionCreator.isMakingLink()) ||
				ConnectionCreator.isMakingLinkTargetAlreadySet()){
			setSource.setEnabled(true);
			setSource.addActionListener(new SetLinkSourceAction(segment));
		}else{
			setSource.setEnabled(false);
		}
		if(href){
			setSource.setEnabled(false);
		}
		this.add(setSource);
	
		JMenuItem setTarget = new JMenuItem("Set Link Target");
		if((!ConnectionCreator.isMakingLink()) ||
				ConnectionCreator.isMakingLinkSourceAlreadySet()){
			setTarget.setEnabled(true);
			setTarget.addActionListener(new SetLinkTargetAction(segment));
		}else{
			setTarget.setEnabled(false);
		}
		if(href){
			setTarget.setEnabled(false);
		}
		this.add(setTarget);
		
		
		JMenuItem cancelConnectionCreation = new JMenuItem("Cancel Connection Creation");
		cancelConnectionCreation.addActionListener(new cancelConnectionCreationAction());
		if(href){
			cancelConnectionCreation.setEnabled(false);
		} else if(ConnectionCreator.isMakingLink()) {
			cancelConnectionCreation.setEnabled(true);
		} else {
			cancelConnectionCreation.setEnabled(false);
		}
		this.add(cancelConnectionCreation);
		
		this.addSeparator();

		boolean registered = GS_RWRepository.getInstance().isRegistered(segment);

		if (registered) {
			JMenuItem showInRW = new JMenuItem("Show in RW");
			showInRW.addActionListener(new ShowInRWAction(segment));
			this.add(showInRW);
		} else {
			JMenuItem registerRegion = new JMenuItem("Register with RW");
			registerRegion.addActionListener(new RegisterSegmentAction(segment));
			this.add(registerRegion);
		}
		
		this.addSeparator();

		
		JMenuItem removeMarkup = new JMenuItem("Remove Markup");
		removeMarkup.addActionListener(new RemoveMarkupAction(segment, textPane, point));
		this.add(removeMarkup);
		
		JMenuItem setExternal = new JMenuItem("Set External Link");
	    setExternal.addActionListener(new SetExternalLinkAction(segment,textPane,point));
	    if(ConnectionCreator.getSource() != null){
	    	setExternal.setEnabled(false);
	    }
		this.add(setExternal);

		JMenuItem removeExternal = new JMenuItem("Remove External Link");
	    removeExternal.addActionListener(new RemoveExternalLinkAction(segment,textPane,point));
		this.add(removeExternal);
		removeExternal.setEnabled(externallink);

		JMenuItem webjump = new JMenuItem("Show Web Page");
		webjump.addActionListener(new JumpWebPageAction(textPane,point));
		this.add(webjump);
		webjump.setEnabled(externallink);

		JMenu basket = new JMenu("Add to Basket");
		List<GSResource> baskets = GS_RWRepository.getInstance().getResourceBaskets();
		for (int i = 0; i < baskets.size(); i++) {
			JMenuItem item = new JMenuItem(baskets.get(i).getName());
			item.addActionListener(new AddToBasketAction((ResourceBasket) baskets.get(i), segment));
			basket.add(item);
		}
		this.add(basket);
		JMenuItem basketFrame = new JMenuItem("Send to Basket List");
		basketFrame.addActionListener(new AddToBasketAction(segment));
		this.add(basketFrame);


	}
	
	class RegisterSegmentAction implements ActionListener {

		private TextSegment segment;
		
		RegisterSegmentAction(TextSegment segment) {
			this.segment = segment;
		}
		
		@Override
		public void actionPerformed(ActionEvent e) {
			GS_RWRepository.getInstance().createResourcePointer(this.segment);			
		}
		
	}
}
