/* $Id: ResourcePointerView.java 1080 2016-03-30 00:49:23Z minao $ */
package smart_gs.reasoning_web.swingui.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import reasoning_web.logical.ResourcePointer;
import smart_gs.reasoning_web.logical.GS_RWElement;

public class ResourcePointerView extends View {

	private ResourcePointer pointer;
	
	protected Rectangle2D rect;
	protected final int MARKER_SIZE=4;	/*選択時のマーカーサイズ*/
	protected boolean toBeFilled = false;
	
	private static  int WIDTH = 15;
	private static  int HEIGHT = 15;
	
	private static  int NOT_INITIALIZED = -1;
	
	private static  int STANDBY_AREA_X = 20;
//	private static  int STANDBY_AREA_Y = 5000;
	
	private static  int STANDBY_AREA_X_WITH_OFFSET = STANDBY_AREA_X - WIDTH;
//	private static  int STANDBY_AREA_Y_WITH_OFFSET = STANDBY_AREA_Y - HEIGHT;
	
	private static  int STANDBY_AREA_X_DEFAULT = STANDBY_AREA_X/2 - WIDTH/2;
	private static  int STANDBY_AREA_Y_DEFAULT = 10;

	private String uri;

	private String name = "";

	/**
	 * @param sourceView
	 */
	public ResourcePointerView(int x, int y, ResourcePointer pointer) {
		this.pointer = pointer;
		
		if (! pointer.isZombieByRestore()) {
			this.uri = ((GS_RWElement) this.getElement().getGSResource()).getURI();		
		} else {
			this.uri = pointer.getZombieURI();
		}

		// 2007/10/24 kazuhiro kobayashi
		// this.WIDTH += this.uri.length() + 5;
		//
		this.rect = new Rectangle2D.Double(x, y, WIDTH, HEIGHT);
		// this.name = this.element.getNote().getName();
	}
	
	/**
	 * @param sourceView
	 */
	public ResourcePointerView(ResourcePointer element) {
		this(STANDBY_AREA_X_DEFAULT,STANDBY_AREA_Y_DEFAULT,element);
	}

	@Override
	public void drawShape(Graphics2D g) {
		boolean zombified = this.pointer.isZombified();
		int int_x = (int) this.rect.getX();
		int int_y = (int) this.rect.getY();
		
		g.setStroke(new BasicStroke(1));
		
		if (inStandbyArea(int_x, int_y)) {
			setColorStandby();
		} else if (inAssignedAread(int_x, int_y)) {
			setColorAssigned();
		} else if (inBorder_X(int_x, int_y)) {
				setColorStandby();
		} 
		Color defaultColor=g.getColor();
		g.setColor(this.currentColor);
		g.fill(this.rect);		
		if(this.isSelected){
			g.setColor(Color.RED);
		}else{
			g.setColor(Color.BLACK);
		}
		
		g.draw(rect);
   		if (toBeFilled || this.isSelected) {
   			g.fill(rect);
   		}
		
		g.setColor(defaultColor);
		
		int x = (int) this.rect.getMinX() + 20; // +5や+1は微調整、値に意味はない
		int y = (int) this.rect.getCenterY() + 1;
		// g.drawString(this.element.getElementRank()+"",x,y);
		// 2007/11/23 kazuhiro kobayashi
		this.name = this.pointer.getName();
		String header = "";
		if (zombified) header = "Zombie:";
		if (!this.name.equals("")) {
			g.drawString(header + this.name, x, y);
		} else {
			g.drawString(header + this.uri, x, y);
		}
		if (zombified) g.fill(this.rect);
	}

	private static boolean inStandbyArea (int x, int y) {
		return x <= STANDBY_AREA_X_WITH_OFFSET;
	}
	
	private static boolean inAssignedAread (int x, int y) {
		return x > STANDBY_AREA_X;
	}
	
	private static boolean inBorder_X (int x, int y) {
		return !(x <= STANDBY_AREA_X_WITH_OFFSET) & !(x > STANDBY_AREA_X);
	}
	
	private static boolean inBorder_Y (int x, int y) {
		return !(y > STANDBY_AREA_X);
	}
	
	public void adjustLocation () {
		int int_x = (int)this.rect.getX();
		int int_y = (int)this.rect.getY();

		if (inStandbyArea(int_x, int_y)) {
			this.rect = new Rectangle2D.Double(int_x,int_y,WIDTH,HEIGHT);
			setColorStandby();
		} else if (inAssignedAread(int_x, int_y)) {
			this.rect = new Rectangle2D.Double(int_x,int_y,WIDTH,HEIGHT);
			setColorAssigned();
		} else if (inBorder_X(int_x, int_y)) {
			if (!inBorder_Y(int_x, int_y)){
				this.rect = new Rectangle2D.Double(STANDBY_AREA_X_DEFAULT,int_y,WIDTH,HEIGHT);
				setColorStandby();
			} 
		} else 		
			this.rect = new Rectangle2D.Double(STANDBY_AREA_X_DEFAULT,STANDBY_AREA_Y_DEFAULT,WIDTH,HEIGHT);
	}
	
	public String toString() {
		return "" + pointer;
	}

	private void setColorAssigned () {
		this.currentColor = Color.white;
		this.defaultColor = Color.white;
	}
	
	private void setColorStandby () {
		this.currentColor = Color.gray;
		this.defaultColor = Color.gray;
	}
	
	private void setColorZombie () {
		this.currentColor = Color.black;
		this.defaultColor = Color.black;
	}

	public boolean contains(Point2D point) {
		return rect.contains(point);
	}

	public void moveBy(Point2D d) {
	    this.rect = new Rectangle2D.Double(rect.getX()+d.getX(),rect.getY()+d.getY(),rect.getWidth(),rect.getHeight());
	}
	
	public void fill() {
		toBeFilled = true;
	}
	
	public void unfill() {
		toBeFilled = false;
	}

	public void select(Graphics2D g){
		Rectangle2D bound=rect.getBounds2D();
		
		BasicStroke stroke=(BasicStroke)g.getStroke();
		
		/*点線の作成*/
		float[] dashPhase={2,2};
		g.setStroke(new BasicStroke(stroke.getLineWidth(),
											stroke.getEndCap(),
											stroke.getLineJoin(),
											stroke.getMiterLimit(),
											dashPhase,
											0));

		g.draw(bound);
		g.setStroke(stroke);
		
		this.setMarker(g,new Point2D.Double( bound.getMinX()-MARKER_SIZE, bound.getMinY()-MARKER_SIZE));
		this.setMarker(g,new Point2D.Double( bound.getMaxX(), bound.getMinY()-MARKER_SIZE));
		this.setMarker(g,new Point2D.Double( bound.getMinX()- MARKER_SIZE,bound.getMaxY()));
		this.setMarker(g,new Point2D.Double( bound.getMaxX(), bound.getMaxY()));
	
	}
	public Rectangle2D getShape() {
		return this.rect;
	}

	public ResourcePointer getElement() {
		return this.pointer;
	}

	// 2007/10/22 kazuhiro kobayahsi
	public Rectangle2D getRectangle() {
		return this.rect;
	}

	public void setRectangle(double x, double y, double w, double h) {
		this.rect = new Rectangle2D.Double(x, y, w, h);
	}

	public void setRectangle(double x, double y) {
		this.rect = new Rectangle2D.Double(x, y, WIDTH, HEIGHT);
	}

	public boolean isInStanbyArea() {
		return inStandbyArea((int)this.rect.getX(),(int)this.rect.getY());
	}

}
