package smart_gs.reasoning_web.swingui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.List;

import reasoning_web.logical.ResourcePointer;
import smart_gs.reasoning_web.logical.GSResourcePointer;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.reasoning_web.swingui.view.ResourcePointerView;
import smart_gs.reasoning_web.swingui.view.View;

public class SortUnarrangedAction implements ActionListener {

	@Override
	public void actionPerformed(ActionEvent arg0) {
		GS_RWRepository repo = GS_RWRepository.getInstance();
		List<ResourcePointer> pointers = repo.getResourcePointers();
		int length = pointers.size();
		int count = 0;
		for (int i = 0; i < length; i++) {
			GSResourcePointer current_pointer = (GSResourcePointer)pointers.get(i);
			ResourcePointerView view = (ResourcePointerView)current_pointer.getView();
			if (view.isInStanbyArea()) {
				view.moveBy(new Point2D.Double(0,30*count));
				count++;
			}
		}
		ReasoningWebFrame.getInstance().repaint();
	}

}
