/* $Id: LocalViewPanel.java 1085 2016-04-03 03:01:02Z minao $ */
package smart_gs.reasoning_web.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import reasoning_web.logical.Connection;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.GSConstants;
import smart_gs.drawing_tool.action.ShowInRWAction;
import smart_gs.logical.GSResource;
import smart_gs.logical.Region;
import smart_gs.logical.TextSegment;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.reasoning_web.logical.GSResourcePointer;
import smart_gs.reasoning_web.swingui.action.ShowExplanatoryAction;
import smart_gs.util.Quadruple;

@SuppressWarnings("serial")
public class LocalViewPanel extends JPanel {

	// 2009/02/26 ADD NorthGrid
	private JTextField nameField;
	private static final int BOX_HEIGHT = GSConstants.ELEMENT_VIEW_PANEL_FOR_LOCAL_VIEW_SIZE;

	public LocalViewPanel(ArrayList<Quadruple<Connection, GSResourcePointer, GSExplanatoryNote, Integer>> elements,
			LocalViewFrame parent) {
		super();
		this.setLayout(new GridLayout(elements.size(), 1));

		Enumeration<Quadruple<Connection, GSResourcePointer, GSExplanatoryNote, Integer>> enume = Collections.enumeration(elements);

		while (enume.hasMoreElements()) {
			Quadruple<Connection, GSResourcePointer, GSExplanatoryNote, Integer> quadruple = enume.nextElement();
			Connection connection = quadruple.getFirst();
			String connectionName = connection.getName();
			GSResourcePointer pointer = quadruple.getSecond();
			GSExplanatoryNote expNote = quadruple.getThird();
			Integer peer_edge_type = quadruple.getFourth();

			JSplitPane rowForConnection = new JSplitPane();
	
			if (peer_edge_type == Connection.SOURCE) {
				rowForConnection.setBorder(new TitledBorder("Source: "
						+ pointer.getURI()));
			} else if (peer_edge_type == Connection.TARGET){
				rowForConnection.setBorder(new TitledBorder("Target: "
						+ pointer.getURI()));
			} else {
				rowForConnection.setBorder(new TitledBorder("Linked to itself: "
						+ pointer.getURI()));
			}

			int width = GSConstants.ELEMENT_VIEW_PANEL_FOR_LOCAL_VIEW_SIZE;
			int height = GSConstants.ELEMENT_VIEW_PANEL_FOR_LOCAL_VIEW_SIZE;

			rowForConnection.setDividerLocation(width);
			
			try {
				JPanel elementViewPanel;
				if (pointer.isZombified()) {
					elementViewPanel = ZombiePanel.getZombieElementViewPanelForLocalView(pointer.getURI());
				} else {
					GSResource resource = pointer.getGSResource();
					if (resource instanceof Region) {
						Region region = (Region)resource;
						if (region.isZombie()) {
							elementViewPanel = ZombiePanel.getZombieElementViewPanelForLocalView(pointer.getURI());
						} else {
							elementViewPanel = ((Region)resource).createElementViewPanelForLocalView();
						}
					} else if (resource instanceof TextSegment) {
						TextSegment segment = (TextSegment)resource;
						elementViewPanel = segment.createElementViewPanelForLocalView();
						if (elementViewPanel == null) {
							elementViewPanel = ZombiePanel.getZombieElementViewPanelForLocalView(pointer.getURI());
						} 
					} else {
						JPanel panel = new JPanel();
						panel.setPreferredSize(new Dimension(width, height));
						panel.setBackground(Color.ORANGE);
						
						elementViewPanel = panel;
					}
				}
				rowForConnection.setLeftComponent(elementViewPanel);
			} catch (NoWayToShowException e) {
				e.printStackTrace();
			}

			try {
				JPanel panel = new JPanel();
				panel.setLayout(new GridLayout(4,1));
				panel.setPreferredSize(new Dimension((int)(BOX_HEIGHT*1.5),BOX_HEIGHT));
				
				nameField = new JTextField(15);
				nameField.setBorder(new TitledBorder("Connection Name"));
				nameField.setText(connectionName);
				panel.add(nameField);		
				
				JButton editButton = new JButton("Explanatory Note");
				panel.add(editButton);
				editButton.addActionListener(new ShowExplanatoryAction(expNote));
				
				JButton deleteButton = new JButton("Delete Connection");
				panel.add(deleteButton);
				deleteButton.addActionListener(new DeleteConnectionAction(connection,rowForConnection,this,parent));
				
				JButton showInRWButton = new JButton("Show in RW");
				panel.add(showInRWButton);
				showInRWButton.addActionListener(new ShowInRWAction(connection));

				
				rowForConnection.setRightComponent(panel);

			} catch (Exception e) {
				e.printStackTrace();
			}
			this.add(rowForConnection);
		}
	}

	public void removeComponent(JSplitPane rowForConnection) {
		// TODO Auto-generated method stub
		
	}
}
