package smart_gs.reasoning_web.swingui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;
import javax.swing.JSplitPane;

import reasoning_web.logical.Connection;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.reasoning_web.logical.GSResourcePointer;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.util.Quadruple;

public class DeleteConnectionAction implements ActionListener {

	Connection connection;
	JSplitPane rowForConnection;
	LocalViewPanel localViewPanel;
	LocalViewFrame parent;
	 
	public DeleteConnectionAction(Connection connection, JSplitPane rowForConnection, LocalViewPanel localViewPanel, LocalViewFrame parent) {
		this.connection  = connection;
		this.rowForConnection = rowForConnection;
		this.localViewPanel = localViewPanel;
		this.parent = parent;
	}

	@SuppressWarnings("deprecation")
	@Override
	public void actionPerformed(ActionEvent arg0) {
		int i = JOptionPane.showConfirmDialog(null, "Delete this connection?");
		if(i == JOptionPane.YES_OPTION){
			GS_RWRepository.getInstance().removeConnection(this.connection);
			this.rowForConnection.setVisible(false);
			this.localViewPanel.validate();
			this.parent.repaint();
		}

	}

}
