/* $Id: RightClickPopupMenu.java 326 2011-08-27 05:24:05Z shayashi $ */
package smart_gs.reasoning_web.desktop.swingui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

import reasoning_web.logical.Connection;
import smart_gs.reasoning_web.desktop.logical.DeskTopFolder;
import smart_gs.reasoning_web.desktop.logical.DesktopElement;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.swingui.WorkspaceWindow;

@SuppressWarnings("serial")
public class RightClickPopupMenu extends JPopupMenu {
	
	private DeskTopFolder folder;
	private DesktopElement selectedElement;
	
	public RightClickPopupMenu(DeskTopFolder folder) {
		this.folder = folder;
		JMenuItem createFolder = new JMenuItem("Create New Folder");
		createFolder.addActionListener(new CreateNewFolder());
		this.add(createFolder);
//		TODO implement this and add create folder button to the left next to "Delete Selections" button.
//		JMenuItem deleteFolder = new JMenuItem("Delete Folder");
//		deleteFolder.addActionListener(new DeleteFolder());
//		this.add(deleteFolder);
	}

	class CreateNewFolder implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			String name = JOptionPane.showInputDialog("input folder name","new folder");
			if(name == null){
				return;
			}
			folder.add(new DeskTopFolder(folder,name));
			WorkspaceWindow.setUpdated(true);
		}
	}
	
	class DeleteFolder implements ActionListener {
		public void actionPerformed(ActionEvent e) {
		}
	}
	
}
