package smart_gs.network;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;

import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import jp.ac.nii.hcp.shared.model.HCPProject;
import smart_gs.swingui.ButtonDialog;

public class RevisionRangeDialog extends ButtonDialog {

	private static final int HEAD = 0;
	private JTextField fromField;
	private JTextField toField;
	private int latest;

	public RevisionRangeDialog() {
		super(ProjectExplorer.getInstance(), "Range of revisions");
		this.setSize(new Dimension(300,150));
		HCPProject project = ProjectExplorer.getInstance().getSelectedProjectInRepository();
		
		this.latest = 10;
		JLabel fromLabel = new JLabel("From: ");
		JLabel toLabel = new JLabel("  To: ");
		this.fromField = new JTextField();
		this.toField = new JTextField("Head");
		JLabel latestRevisionMessage = new JLabel("The latest revision is " + this.latest);
		JPanel inputPanel = new JPanel();
		inputPanel.setLayout(new BoxLayout(inputPanel, BoxLayout.X_AXIS));
		inputPanel.add(fromLabel);
		inputPanel.add(fromField);
		inputPanel.add(toLabel);
		inputPanel.add(toField);
		this.getContentPane().add(inputPanel, BorderLayout.NORTH);
		this.getContentPane().add(latestRevisionMessage, BorderLayout.CENTER);
	}



	@Override
	public void ok() {
		int from = Integer.parseInt(this.fromField.getText());
		int to = 10;
		if (this.toField.getText().equals(HEAD)) {
			to = this.latest;
		} else {
			to = Integer.parseInt(this.toField.getText());
		}
		if (from < 1 || to < from || HEAD < to) {
			JOptionPane.showMessageDialog(ProjectExplorer.getInstance(), "Invalid revision numbers.");
			return;
		}
		new UploadHistoryWindow(from, to).setVisible(true);
	}

	@Override
	public void cancel() {
		// TODO Auto-generated method stub
		
	}}
