package smart_gs.network;

import java.io.File;
import java.io.IOException;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import smart_gs.SmartGS;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadTree;
import smart_gs.swingui.WorkspaceWindow;

import jp.ac.nii.hcp.client.core.HCPController;
import jp.ac.nii.hcp.client.core.ProjectEditor;
import jp.ac.nii.hcp.client.shared.HCPClientException;
import jp.ac.nii.hcp.shared.model.HCPDocument;
import jp.ac.nii.hcp.shared.model.HCPProject;

public class ProjectLoader {
	private ProjectEditor editor;
	
	public ProjectLoader(ProjectEditor editor) {
		this.editor = editor;
	}

	public List<HCPDocument> getDocuments() throws HCPClientException {
		return this.editor.getDocuments();
	}
	
	
	public void loadSpreadTreeDocument(String id) throws HCPClientException, ParserConfigurationException, SAXException, IOException {
		HCPDocument hcpDoc = editor.getDocument(id);
		DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
		Document xmlDoc = builder.parse(hcpDoc.source);
		Element spreadTreeElement = xmlDoc.getDocumentElement();
		SpreadTree.getInstance().restore(spreadTreeElement);
	}
	public void loadSpreadTreeDocument(File file) throws SAXException, IOException, ParserConfigurationException {
		DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
		Document xmlDoc = builder.parse(file);
		Element spreadTreeElement = xmlDoc.getDocumentElement();
		SpreadTree.getInstance().restore(spreadTreeElement);		
	}

}
