package smart_gs.network;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import smart_gs.GSConstants;
import smart_gs.logical.Preference;
import smart_gs.menu.DirectorySettingWindow;
import smart_gs.menu.action.SetCurrentDirectoryAction;
import smart_gs.menu.action.SetDirectoryPathAction;
import smart_gs.swingui.ButtonFrame;
import smart_gs.swingui.WorkspaceWindow;

class NewProjectDialogFrame extends ButtonFrame implements ActionListener {
	
	private JPanel configurationSettingPanel;
	
	private JPanel repositoryAPIPanel;
	private JTextField repositoryAPIField;

	private JPanel authPanel;
	private JTextField authField;

	private JPanel imageServerPanel;
	private JTextField imageServerField;
	
	private JPanel workspaceDirectoryPanel;
	private JTextField workspaceDirectoryField;
	
	private JPanel projectNamePanel;
	private JTextField projectNameField;
	
//	private JPanel userNamePanel;
//	private JTextField userNameField;
//
//	private JPanel passPanel;
//	private JPasswordField  passField;

	private JPanel buttonPanel;
	private JButton clearButton;
	private JButton resetToDefaultButton;


	public NewProjectDialogFrame() {
		super("Create New Project");
		
		this.setAlwaysOnTop(true);
		this.setResizable(false);

		this.repositoryAPIPanel = new JPanel(new FlowLayout());
		this.repositoryAPIPanel.setBorder(new TitledBorder("Repository API URL"));
		this.repositoryAPIField = new JTextField(20);
		this.repositoryAPIField.setText(Preference.getInstance().getRepositoryAPIUri());
		this.repositoryAPIPanel.add(repositoryAPIField);

		this.authPanel = new JPanel(new FlowLayout());
		this.authPanel.setBorder(new TitledBorder("Authorization URL"));
		this.authField = new JTextField(20);
		this.authField.setText(Preference.getInstance().getAuthUri());
		this.authPanel.add(authField);

		this.imageServerPanel = new JPanel(new FlowLayout());
		this.imageServerPanel.setBorder(new TitledBorder("Image Server URL"));
		this.imageServerField = new JTextField(20);
		this.imageServerField.setText(Preference.getInstance().getImageServerUri());
		this.imageServerPanel.add(imageServerField);
		
		this.workspaceDirectoryPanel = new JPanel(new FlowLayout());
		this.workspaceDirectoryPanel.setBorder(new TitledBorder("Workspace Directory"));
		this.workspaceDirectoryField = new JTextField(20);
		String dir = Preference.getInstance().getWorkspaceDirectory();
		if (dir != null) {
			this.workspaceDirectoryField.setText(dir);			
		} else {
			this.workspaceDirectoryField.setText("");
		}
		JButton selectDirectoryButton = new JButton("Select");
		selectDirectoryButton.addActionListener(new SelectDirectoryButtonAction(this));
		this.workspaceDirectoryPanel.add(workspaceDirectoryField);
		this.workspaceDirectoryPanel.add(selectDirectoryButton);

		this.projectNamePanel = new JPanel(new FlowLayout());
		this.projectNamePanel.setBorder(new TitledBorder("Project Name"));
		this.projectNameField = new JTextField(20);
		this.projectNameField.setText("");
		this.projectNamePanel.add(projectNameField);

		
//		this.userNamePanel = new JPanel(new FlowLayout());
//		this.userNamePanel.setBorder(new TitledBorder("ID"));
//		this.userNameField = new JTextField(20);
//		this.userNameField.setText(Preference.getInstance().getUserName());
//		this.userNamePanel.add(userNameField);
//
//		this.passPanel = new JPanel(new FlowLayout());
//		this.passPanel.setBorder(new TitledBorder("Password"));
//		this.passField = new JPasswordField(20);
//		this.passField.setText("");
//		this.passPanel.add(passField);

		this.clearButton = new JButton("Clear");
		this.clearButton.addActionListener(new ClearActionListener(this));
		this.resetToDefaultButton = new JButton("Default");
		this.resetToDefaultButton.addActionListener(new ResetActionListener(this));
		this.buttonPanel = new JPanel(new GridLayout(1,2));
		this.buttonPanel.add(this.clearButton);
		this.buttonPanel.add(this.resetToDefaultButton);

		this.configurationSettingPanel = new JPanel(new GridLayout(6, 1));
		this.configurationSettingPanel.add(this.repositoryAPIPanel);
		this.configurationSettingPanel.add(this.authPanel);
		this.configurationSettingPanel.add(this.imageServerPanel);
		this.configurationSettingPanel.add(this.workspaceDirectoryPanel);
		this.configurationSettingPanel.add(this.projectNamePanel);
//		this.configurationSettingPanel.add(this.userNamePanel);
//		this.configurationSettingPanel.add(this.passPanel);
		this.configurationSettingPanel.add(this.buttonPanel);
		
		this.getContentPane().add(this.configurationSettingPanel, BorderLayout.CENTER);
		this.pack();

	}

	@Override
	public void ok() {
		ProjectHandler handler = ProjectHandler.getInstance();
		this.dispose();
		handler.setRepositoryAPIUrl(this.repositoryAPIField.getText());
		handler.setAuthUrl(this.authField.getText());
		handler.setImageServerUrl(this.imageServerField.getText());
		handler.setWorkspaceDirectory(this.workspaceDirectoryField.getText());
		handler.setNewProjectName(this.projectNameField.getText());
		handler.create();
	}

	@Override
	public void cancel() {
		this.dispose();
	}
	

	private class ClearActionListener implements ActionListener {
		private NewProjectDialogFrame parent;
		public ClearActionListener(
				NewProjectDialogFrame parent) {
			this.parent = parent;
		}

		@Override
		public void actionPerformed(ActionEvent arg0) {
			parent.repositoryAPIField.setText("");
			parent.authField.setText("");
			parent.imageServerField.setText("");
			parent.repaint();
		}
	}

	private class ResetActionListener implements ActionListener {
		private NewProjectDialogFrame parent;
		public ResetActionListener(
				NewProjectDialogFrame parent) {
			this.parent = parent;
		}

		@Override
		public void actionPerformed(ActionEvent e) {
			parent.repositoryAPIField.setText(Preference.getInstance().getRepositoryAPIUri());
			parent.authField.setText(Preference.getInstance().getAuthUri());
			parent.imageServerField.setText(Preference.getInstance().getImageServerUri());
			parent.repaint();
		}

	}
	
	public class SelectDirectoryButtonAction extends SetDirectoryPathAction {

		private NewProjectDialogFrame parent;
		public SelectDirectoryButtonAction(NewProjectDialogFrame parent) {
			super();
			this.parent = parent;
		}


		@Override
		protected String getOldPath() {
			return Preference.getInstance().getWorkspaceDirectory();
		}

		@Override
		protected void validateNewPath(String newPath) {
			this.parent.workspaceDirectoryField.setText(newPath);
		}

	}

}
