package smart_gs.network;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;

import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import jp.ac.nii.hcp.client.core.ImageContentManager;
import jp.ac.nii.hcp.shared.model.HCPImage;
import jp.ac.nii.hcp.shared.model.HCPImageList;


import smart_gs.swingui.ButtonDialog;
import smart_gs.swingui.WorkspaceWindow;

public class ImageDownloadDialog extends ButtonDialog {
	
	private JList imageList;
	private JScrollPane sPane;
	private int page = 0;
	private String id;

	public ImageDownloadDialog(String id) {
		super(WorkspaceWindow.getInstance(), "Download Image");
		this.id = id;
		this.imageList = makeList(id, this.page);
		this.sPane = new JScrollPane();
		this.sPane.setSize(300, 300);
		this.setSize(300, 500);
		this.sPane.add(this.imageList);
		
		JPanel north = new JPanel();
		north.add(this.sPane);
		this.getContentPane().add(north, BorderLayout.NORTH);
		
		JPanel center = new JPanel();
		JButton next = new JButton("Next");
		next.addActionListener(new PageMoveActionListener(this, page + 1));
		JButton prev = new JButton("Previous");
		prev.addActionListener(new PageMoveActionListener(this, page - 1));
		center.add(prev);
		center.add(next);
		this.getContentPane().add(center, BorderLayout.CENTER);
		
	}

	private JList makeList(String id, int page) {
		ImageContentManager icm = ProjectHandler.getInstance().getImageManager();
		try {
			HCPImageList hcpImageList = icm.search(id, page, null);
			JList list = new JList();
			DefaultListModel model = new DefaultListModel();
			for (int i = 0; i < hcpImageList.images.size(); i++) {
				model.addElement(hcpImageList.images.get(i));
			}
			list.setModel(model);
			return list;
		} catch (IOException e) {
			e.printStackTrace();
			new ShowResultDialog("Image Download", e).setVisible(true);
			return null;
		}
	}

	@Override
	public void ok() {
		int index = this.imageList.getSelectedIndex();
	}

	@Override
	public void cancel() {
		// TODO Auto-generated method stub
		
	}
	
	class PageMoveActionListener implements ActionListener {
		
		private ImageDownloadDialog dialog;
		private int page;
		
		public PageMoveActionListener(ImageDownloadDialog dialog, int page) {
			this.dialog = dialog;
			this.page = page;
		}

		@Override
		public void actionPerformed(ActionEvent arg0) {
			JList newList = makeList(dialog.id, this.page);
			dialog.sPane.removeAll();
			dialog.sPane.add(newList);
			dialog.repaint();
		}
		
	}

}

//イメージサーバの画像をすべて取得するメソッドは存在しません。
//ImageContentMangerのsearch()メソッドで指定した
//ユーザやグループのIDにより一覧を取得できます。

//(1) 画像を管理するオブジェクトを取得。
//ImageContentManager icm = hcp.getImageManager();

//(2) URLとパスを構成する情報を指定して、画像を画像URIサーバに登録。
//HCPImage image1 = icm.add(auth.user, "S09_001", "http://kyoto-gakuha.info/htmlimg/LectureNotesS09_ver2/S09_001.jpg");
//第二引数は画像を登録する際の画像の名前で、これがパスの要素になります。

//画像のパスを確認
//System.out.println("image7.getPath(): " + image7.getPath());

//(3) 画像を画像ワークスペースにダウンロード。
//ここでは画像のパスを直接指定しています。
//icm.download("/00000005/S09_001", null);

//プロジェクトに画像を追加
//editor.addMaterial("/画像/S09_001", image1.getPath(), "S09_001");