/* $Id: SetDefaultGsFileAction.java 217 2011-06-10 00:53:06Z ohura $ */
package smart_gs.menu;

import java.io.File;

import javax.swing.JFileChooser;

import smart_gs.logical.Preference;
import smart_gs.menu.action.SetDirectoryPathAction;
import smart_gs.swingui.toolbar.action.GSFileFilter;

public class SetDefaultGsFileAction extends SetDirectoryPathAction {

	public SetDefaultGsFileAction(){
		super();
		chooser.setDialogTitle("DefaultのGSファイルの設定");
//		this.dialogTitle = "DefaultのGSファイルの設定";
		chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
		chooser.setFileFilter(new GSFileFilter());
		chooser.setSelectedFile(new File(getOldPath()));
	}
	@Override
	protected String getOldPath() {
		// TODO Auto-generated method stub
		return Preference.getInstance().getDefaultGsFilePathString();
	}

	@Override
	protected void validateNewPath(String newPath) {
		// TODO Auto-generated method stub
		DirectorySettingWindow.getInstance().setDefaultGsFileField(newPath);
	}

}
