/* $Id: ConvertGS.java 898 2014-12-25 02:47:01Z yuta-hashimoto $ */
package smart_gs.logical;

import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConvertGS {
	/**
	 * タグ正規表現
	 */
	private static Pattern tagPattern = Pattern.compile("(<([^ >]+)([^>]*)>)([^<]*)");
	/**
	 * マッチャー
	 */
	private Matcher matcher;

	private HashMap<String,String> ignoreMap = new HashMap<String,String>();
	protected StringBuffer convertStr = new StringBuffer();
	/**
	 * コンストラクタです。
	 * 
	 * @param src
	 *            HTMLソース
	 */
	public ConvertGS(String src) {
		matcher = tagPattern.matcher(src);
		ignoreMap.put("?xml", "");
		ignoreMap.put("xml", "");
		ignoreMap.put("?xml", "");
		ignoreMap.put("/xml", "");
	}

	/**
	 * 次のHTMLタグがあるかどうかを検査します。
	 * 
	 * @return 存在する場合はtrue
	 */
	public String  parser() {
		while (matcher.find()) {
			String tagName = matcher.group(2);
			String tagAttribute = matcher.group(3);
			String tagText = matcher.group(4) ;
//			if(!ignoreMap.containsKey(tagName)){
//				if(tagName.startsWith("/br")){
//					convertStr.append("<br>");
//				}else if(tagName.startsWith("br/")){
//					convertStr.append("<br>");
//				}else if(tagName.startsWith("br")){
//					convertStr.append("<br>");
//				}else if(tagName.startsWith("/")){
//					convertStr.append("</a>");
//				}else{
//					if(tagAttribute.indexOf("href") != -1 && tagAttribute.indexOf("id") != -1){
//						convertStr.append("<a " + tagAttribute + ">");
//					}else{
//						StringTokenizer stsp = new StringTokenizer(tagAttribute, " ");
//				        while (stsp.hasMoreTokens()) {
//				        	String tonkenspStr =  stsp.nextToken();
//				        	if(!tonkenspStr.trim().equals("")){
//								StringTokenizer st = new StringTokenizer(tonkenspStr, "=");
//									boolean isValue = false;
//							        while (st.hasMoreTokens()) {
//						        		String tonkenStr =  st.nextToken();
//							        	if(isValue){
//							        		String value = tonkenStr;
//							        		if(value.startsWith("\"")){
//							        			value = value.substring(1);
//							        		}
//							        		if(value.endsWith("\"")){
//							        			value = value.substring(0,value.length() -1);
//							        		}
//							        		convertStr.append("<a href=\"" + value + "\" id=\"" + tagName + "\">");
//							        	}else{
//							        		if(tonkenStr.toLowerCase().trim().equals("id")){
//							        			isValue = true;;
//							        		}
//							        	}
//							        }
//				        	}
//				        }
//					}
//				}
//			}
			if(!tagText.equals("")){
				convertStr.append(tagText);
			}
		}
		return convertStr.toString();
	}

	public static void main(String[] args) {

		// サンプルのHTMLを用意します。
		StringBuffer sb = new StringBuffer();
		sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><xml>あいうえお<dubious id=\"615\">Geometrie</br></dubious>かきくけこ</br></xml>");

		// パーサオブジェクトを作成します。
		ConvertGS parser = new ConvertGS(sb.toString());
		System.out.println(parser.parser());
	}
}
