package smart_gs.image_search.transcription_tool.swingui;

import java.awt.Dimension;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;

import javax.swing.BoxLayout;
import javax.swing.JPanel;

import smart_gs.image_search.logical.SearchResult;
import sml_editor.logical.LineDirection;

@SuppressWarnings("serial")
public class SearchResultListPanel extends JPanel {
	private int sizeOfResults;
	private int sizeToDisplay;
	private int page = 0;
	private int beginIndex;
	private int endIndex;
	private String transcriptionText;
	private Image queryImage;
	private LineDirection lineDirection;
	private List<SearchResult> results;
	private List<ResultPanel> resultPanels;	

	public SearchResultListPanel(Image queryImage, List<SearchResult> results,
			LineDirection lineDirection, int sizeToDisplay, int sizeOfResults) {
		super();
		this.setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));
		page = 0;
		this.sizeOfResults = sizeOfResults;
		this.sizeToDisplay = sizeToDisplay;
		this.setSize(new Dimension(250, 500));
		this.results = results;
		this.transcriptionText = "";
		this.queryImage = queryImage;
		this.lineDirection = lineDirection;
		this.beginIndex = page * sizeToDisplay; // 最初に表示する result の index
		this.endIndex = Math.min((page + 1) * sizeToDisplay - 1,
				sizeOfResults - 1); // 最後に表示するresult の index		
		this.resultPanels = new ArrayList<ResultPanel>();
		showResults();
	}

	protected void showResults() {
		removeAll();
		resultPanels = new ArrayList<ResultPanel>();
		for (int i = beginIndex; i <= endIndex; i++) {
			ResultPanel resultPanel = 
					new ResultPanel(this, results.get(i), this.transcriptionText,  queryImage, lineDirection);
			this.add(resultPanel);
			this.resultPanels.add(resultPanel);
		}
		updateTranscriptionText(this.transcriptionText);
	}
	
	public void updateTranscriptionText(String text) {
		this.transcriptionText = text;
		for(ResultPanel resultPanel : resultPanels) {
			resultPanel.setTranscriptionText(text);
			resultPanel.updateTranscriptionField();
		}
	}
	
	public void removeResult(SearchResult result) {
		this.results.remove(result);
	}
	
	public void removeResultPanel(ResultPanel result){
		this.results.remove(result.getResult());
		this.remove(result);
		
	}

	public void back() {
		if (page <= 0) {
			page = 0;
			showResults();
		} else {
			page--;
			updateIndex();
			showResults();			
		}
	}

	public void next() {
		if ((page + 1) * sizeToDisplay >= sizeOfResults) {
			showResults();
		} else {
			page++;
			updateIndex();
			showResults();			
		}
	}

	public boolean isBackButton() {
		if (page <= 0) {
			return false;
		}
		return true;
	}

	public boolean isNextButton() {
		if ((page + 1) * sizeToDisplay >= sizeOfResults) {
			return false;
		}
		return true;
	}

	public void updateIndex() {
		this.beginIndex = page * sizeToDisplay;
		this.endIndex = Math.min((page + 1) * sizeToDisplay - 1,
				sizeOfResults - 1);
	}
	
	public void transcribe(int transcribeIndex) {
		
	}	

	public void selectAllThisPage(boolean selected) {
		for (int i = this.beginIndex; i <= this.endIndex; i++) {
			resultPanels.get(i).setSelected(selected);
		}			
	}

	public void selectAll(boolean selected) {
		boolean isAllSelected = true;
		for (ResultPanel result : resultPanels){
			isAllSelected = isAllSelected && result.isSelected();
		}
		for (ResultPanel result : resultPanels){
			result.setSelected(!isAllSelected);
		}
	}

	public int getPage() {
		return page+1;
	}
}
