package smart_gs.image_search.normal.swingui;

import java.awt.GridLayout;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;

import smart_gs.image_search.logical.SearchResult;
import smart_gs.image_search.logical.TextType;
import smart_gs.logical.Spread;
import smart_gs.util.ImageCropper;
import sml_editor.logical.LineDirection;

public class TranscriptionToolNo1SegmentsPanel extends AbstractTranscriptionPanel {
	
	private int row;
	private int column;
	
	//Horizontal mode corrections
	private int widthCorrectionHmode = 50;
	private int heightCorrectionHmode = 0;
	//20080715 shimizu, 20110422 shayashi
	//Vertical mode corrections
	private int widthCorrectionVmode = 0;
	private int heightCorrectionVmode = 50;
	// general magnification rate
	private double magnification = 0.7;
	
	private LineDirection lineDirection;

	public TranscriptionToolNo1SegmentsPanel(TranscriptionToolNo1Frame parent,List<SearchResult> results,Image queryImage,LineDirection lineDirection) {
		super(parent,results,queryImage,lineDirection);
		
		this.lineDirection = parent.getLineDirection();
		
		if (this.lineDirection == LineDirection.HORIZONTAL) {
			row = 6;
			column = 5;
			if (queryImage.getWidth(this)<queryImage.getHeight(this)) {
				int tmp;
				tmp = column;
				column = row;
				row = tmp;
			}
		} else {
			row = 4;
			column = 6;
			if (queryImage.getWidth(this)>queryImage.getHeight(this)) {
				int tmp;
				tmp = column;
				column = row;
				row = tmp;
			}
		}

		this.SIZE_TO_DISPLAY = row * column;
		this.setLayout(new GridLayout(row,column));
		this.nextCount = this.count + 1;
		this.createNextResults(this.count,this.lineDirection);
		this.showResult(this.nextResults);
		this.createNextResults(nextCount,this.lineDirection);
	}

	@Override
	protected JLabel createImageLabel(SearchResult result, Image queryImage) {
		Spread spread = result.getSpread();
		Rectangle2D rect = result.getRectangle();
		int width = queryImage.getWidth(null);
		int height = queryImage.getHeight(null);
		
		//parameters to adjust image size by ImageCropper.crop.
		if(this.lineDirection == LineDirection.HORIZONTAL){
			width = width + this.widthCorrectionHmode;
			height = height + this.heightCorrectionHmode;
		}else{
			width = width + this.widthCorrectionVmode;
			height = height + this.heightCorrectionVmode;
		}
		width *= magnification;
		height *= magnification;
		
		if (this.lineDirection == LineDirection.HORIZONTAL && height>50) {
			double ratio2 = 50.0 /  height;
			width *= ratio2;
			height *= ratio2;
		} else if (this.lineDirection != LineDirection.HORIZONTAL&& width>50) {
			double ratio2 = 50.0 /  width;
			width *= ratio2;
			height *= ratio2;
		}
		
		Image image = new ImageCropper(spread,rect).crop(width,height);
		
		JLabel label = new JLabel(new ImageIcon(image));
		
		JWindow window = new ResultPopupWindow(result);
		label.addMouseListener(new LabelMouseListener(label,window,spread,rect));
		return label;
	}
}
