package smart_gs.image_search.normal.swingui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import smart_gs.image_search.logical.SearchResult;
import smart_gs.logical.LineSegment;
import smart_gs.logical.Spread;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.transcription_tool.TranscriptionToolNo1;

public class TranscriptionToolNo1Listner implements ActionListener {
	TranscriptionToolNo1Frame transcriptionToolNo1Frame;
	List<SearchResult> results;
	Image queryImage;
	
	public TranscriptionToolNo1Listner(TranscriptionToolNo1Frame transcriptionToolNo1Frame,
			List<SearchResult> results, Image queryImage) {
		this.transcriptionToolNo1Frame = transcriptionToolNo1Frame;
		this.results = transcriptionToolNo1Frame.getSelectedResults();
		this.queryImage = queryImage;
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		TranscriptionToolNo1.aid(this.transcriptionToolNo1Frame,this.results,this.queryImage);			
		for(SearchResult result : this.results){
			System.out.println("Processing " + result.getURI());
			Spread spread = result.getSpread();			
			System.out.println("line num: " + result.getLineIndex());
			
			this.processResult(spread, result);
			this.calcLeftSpace(spread, result);
			WorkspaceWindow.getInstance().updateSpread(spread);
		}
		this.transcriptionToolNo1Frame.dispose();
	}
	
	private String getTranscriptionText() {
		return this.transcriptionToolNo1Frame.getTranscriptionTextField().getText();
	}
	
	private int calcLeftSpace(Spread spread, SearchResult result) {
		int xResult = (int) result.getView().getRectangle().getX();
		int lineIndex = result.getLineIndex();
		int diff = 0;
		if(lineIndex + 1< spread.getLines().size()){
			LineSegment line = spread.getLines().get(lineIndex);
			int xLine = (int) line.getView().getRectangle().getX();
			diff = xResult - xLine;
			if(diff < 0){
				diff = 0;
			}
			System.out.println("Diff: "+ diff);
		}
		return diff;
	}
	
	private void processResult(Spread spread, SearchResult result) {
		int linenum = result.getLineIndex();
		int leftSpace = this.calcLeftSpace(spread, result);
		int numSpace = leftSpace / 20; // 1 white space per 20px (experimental)
		String source = spread.getFirstIDAT().getSource();
		String regex = "(\\$"+ linenum +"\\$ )(.*?)(<br>|</html>)";
		System.out.println("Regex: " + regex);
		Pattern p = Pattern.compile(regex);
		Matcher m = p.matcher(source);
		if (m.find()){
			System.out.println("Match: "+m.group(1));
			String text = this.insertTranscription(m.group(2), this.getTranscriptionText(), numSpace);
			String quoted = Matcher.quoteReplacement(text); // quote dollar chars
			String replaced = m.replaceFirst("$1"+quoted+"$3");
			spread.getFirstIDAT().setSource(replaced);
		}
	}
	
	private String insertTranscription(String original, String transcription, int spacing) {
		String pre;
		String post;
		System.out.println("space"+ spacing);
		if(original.length() > transcription.length() + spacing) {
			pre = original.substring(0, spacing);
			post = original.substring(spacing+transcription.length());
			return pre + transcription + post;
		} else if (original.length() < spacing){
			int diff = original.length() - spacing;
			String space = "";
			for (int i=0; i< diff; i++) {space+=" "; }
			pre = original + space;
			post = "";
		} else {
			pre = original.substring(0, spacing);
			post = "";
		}
		return pre + transcription + post;
	}

}
