/* $Id: SearchMenuBar.java 626 2013-01-13 18:51:36Z shayashi $ */
package smart_gs.image_search.normal.swingui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

import sml_editor.logical.LineDirection;

@SuppressWarnings("serial")
public class SearchMenuBar extends JMenuBar {
	private final int VIEW = 0;
	private final int NEW_RESULT = 0;
	private final int ALL_RESULT = 1;

	private final int OPTION = 1;
	private final int LINE = 0;
	private final int SEGMENT = 1;
	
	private Image queryImage;

	private int[] viewMode = { ALL_RESULT, SEGMENT };

	public SearchMenuBar(final SearchResultViewer parent,final LineDirection lineDirection) {

		this.queryImage = parent.getQueryImage();

		/*
		 * 新しい結果だけを見せるか全て見せるかのメニューの追加
		 */
		JMenu view = new JMenu("View");
		JMenuItem newResult = new JMenuItem("New Results Only");
		
		
		newResult.addActionListener(new ActionListener() {
		    public void actionPerformed(ActionEvent e) {
			AbstractSearchResultPanel resultPanel;
			switch (viewMode[OPTION]) {
			case LINE:
			    resultPanel = new SearchResultPanelOfLineMode(parent, parent.getNewResults(),queryImage,lineDirection);
			    break;
			default:
			    resultPanel = new SearchResultPanelOfSegmentMode(parent, parent.getNewResults(),queryImage,lineDirection);
			    break;
			}
			viewMode[VIEW] = NEW_RESULT;
			parent.setResultPanel(resultPanel);
			parent.validate();
		    }
		});
		JMenuItem allResult = new JMenuItem("All Results");
		allResult.addActionListener(new ActionListener() {
		    public void actionPerformed(ActionEvent e) {
			AbstractSearchResultPanel resultPanel;
			switch (viewMode[OPTION]) {
			case LINE:
			    resultPanel = new SearchResultPanelOfLineMode(parent, parent.getResults(),queryImage,lineDirection);
			    break;
			default:
			    resultPanel = new SearchResultPanelOfSegmentMode(parent, parent.getResults(),queryImage,lineDirection);
			    break;
			}
			viewMode[VIEW] = ALL_RESULT;
			parent.setResultPanel(resultPanel);
			parent.validate();
			
		    }
		});
		view.add(newResult);
		view.add(allResult);
		
		JMenu options = new JMenu("Option");
		JMenu mode = new JMenu("Display Mode");
		options.add(mode);
		
		JMenuItem line = new JMenuItem("Line Mode");
		line.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				/*
				 * 切り替え
				 */
				AbstractSearchResultPanel resultPanel;
				switch (viewMode[VIEW]) {
				case NEW_RESULT:
				    resultPanel = new SearchResultPanelOfLineMode(parent,parent.getNewResults(),queryImage,lineDirection);
				    break;
				default:
				    resultPanel = new SearchResultPanelOfLineMode(parent,parent.getResults(),queryImage,lineDirection);
				    break;
				}
				viewMode[OPTION] = LINE;
				
				
				parent.setResultPanel(resultPanel);
				parent.validate();
			}
		});
		JMenuItem segment = new JMenuItem("Segment Mode");
		segment.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
//				AbstractSearchResultPanel resultPanel = new SearchResultListPanel(
//						parent, parent.getResults());
				

				AbstractSearchResultPanel resultPanel;
				switch (viewMode[VIEW]) {
				case NEW_RESULT:
				    resultPanel = new SearchResultPanelOfSegmentMode(parent,parent.getNewResults(),queryImage,lineDirection);
				    break;
				default:
				    resultPanel = new SearchResultPanelOfSegmentMode(parent,parent.getResults(),queryImage,lineDirection);
				    break;
				}
				viewMode[OPTION] = SEGMENT;
				
				
				parent.setResultPanel(resultPanel);
				parent.validate();
			}
		});
		
		mode.add(line);
		mode.add(segment);


		this.add(view);
		this.add(options);
	}

}
