/* $Id: SearchResult.java 885 2014-09-17 15:19:26Z shayashi $ */
package smart_gs.image_search.logical;

import java.awt.Rectangle;


import smart_gs.drawing_tool.view.RectangleView;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import sml_editor.logical.LineDirection;

public class SearchResult extends Region{
	
	private double score;
	private int rank;
	private int lineIndex;
	private boolean isSelected = false;
	private boolean wasShown = false;
	private boolean isInBucket = false;
	private LineDirection lineDirection;
	

	public SearchResult(Spread spread,Rectangle rectangle,double score,int rank,int lineIndex){
		super(spread,new RectangleView(rectangle));
//		super(spread,new RectangleView(rectangle), spread.getCurrentSheet());
		this.spread = spread;
		this.score = score;
		this.rank = rank;
		this.lineIndex = lineIndex;
		this.lineDirection = spread.getLineDirection();
	}
	public void setWasShown(boolean wasShown){
		this.wasShown = wasShown;
	}
	public boolean wasShown(){
		return this.wasShown;
	}
	public Spread getSpread(){
		return this.spread;
	}
	public int getLineIndex(){
		return this.lineIndex;
	}
	public Rectangle getRectangle() {
		return this.view.getRectangle();
	}
	public double getScore() {
		return score;
	}
	public int getRank() {
		return rank;
	}
	public void setSelected(boolean isSelected){
		this.isSelected = isSelected;
	}
	public boolean isSelected(){
		return this.isSelected;
	}
	public GSQuery toQuery(){
		return new GSQuery(this.spread,this.spread.getDscFile(),this.getRectangle());
	}
	public void setIsInBucket(boolean bool){
		this.isInBucket = bool;
	}
	public boolean isInBucket(){
		return this.isInBucket;
	}
	public void setRectangle(Rectangle rectangle){
		((RectangleView)this.view).setRectangle(rectangle);
	}

	public LineDirection getLineDirection() {
		return lineDirection;
	}
}
