package smart_gs.drawing_tool.drawing_mode;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import smart_gs.drawing_tool.LineSegEditorCanvas;
import smart_gs.drawing_tool.LineSegEditorImageLabel;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.WorkspaceWindow;

public class LineSegEditorSelectMode implements LineSegEditorMode {
	private LineSegEditor editor;
	private int selectedLineIndex;
	LineSegEditorImageLabel imageLabel;

	public LineSegEditorSelectMode(LineSegEditor editor) {
		this.editor = editor;
	}

	@Override
	public void cancel() {
		// TODO Auto-generated method stub

	}

	@Override
	public LineSegEditor getParentLinesegEditor() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void mouseClicked(GSMouseEvent e, LineSegEditorCanvas canvas) {
		boolean ctrlPressed = WorkspaceWindow.getInstance().isCtrl();
		boolean altPressed = WorkspaceWindow.getInstance().isAlt();
		boolean shiftPressed = WorkspaceWindow.getInstance().isShift();
		int clickCount = e.getClickCount();
		int button = e.getButton();
		
		imageLabel = canvas.getLineSegEditorImageLabel();

		if (!(button == MouseEvent.BUTTON1 && clickCount == 1)) return;

		int index = imageLabel.getLineIndex(e.getX(),e.getY());

		if (index<0) imageLabel.resetSelectionOfLines();

		if (index>=0) {
			if (!ctrlPressed && !altPressed && !shiftPressed) {
				imageLabel.resetSelectionOfLines();
				imageLabel.setIsSelected(index,true);
			}

			if (ctrlPressed) {
				imageLabel.setIsSelected(index, ! imageLabel.isSelected(index));
			}
			
			if (shiftPressed) {
				imageLabel.addSelectedRegionOfIndexes(index);
			}
		}

	}

@Override
public void mouseDragged(GSMouseEvent e, LineSegEditorCanvas canvas) {
	// TODO Auto-generated method stub

}

	@Override
	public void mouseEntered(GSMouseEvent e, LineSegEditorCanvas canvas) {
		// TODO Auto-generated method stub

	}

	@Override
	public void mouseExited(GSMouseEvent e, LineSegEditorCanvas canvas) {
		// TODO Auto-generated method stub

	}

	@Override
	public void mouseMoved(GSMouseEvent e, LineSegEditorCanvas canvas) {
		// TODO Auto-generated method stub

	}

	@Override
	public void mousePressed(GSMouseEvent e, LineSegEditorCanvas canvas) {
		// TODO Auto-generated method stub
	}

	@Override
	public void mouseReleased(GSMouseEvent e, LineSegEditorCanvas canvas) {
		// TODO Auto-generated method stub

	}

	@Override
	public void paint(Graphics g,LineSegEditorCanvas canvas) {
//  
	}
	
	
	@Override
	public void setParentLinesegEditor() {
		// TODO Auto-generated method stub

	}

}
