/* $Id: DeleteMode.java 996 2015-09-26 18:02:27Z shayashi $ */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.Component;
import java.awt.geom.Point2D;
import java.util.List;


import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.drawing_tool.action.DeleteRegionAction;
import smart_gs.logical.Region;
public class DeleteMode extends DrawingModeAdapter {
	private Component startcomponent = null;
	private static Mode singleton = new DeleteMode();

	public static Mode getInstance() {
		((DeleteMode)singleton).reset();
		return singleton;
	}
	
	private void reset() {
		startcomponent = null;	
	}
	
	@Override
	public void mouseExited(GSMouseEvent e, SpreadCanvas canvas){
		super.mouseExited(e, canvas);
		if (startcomponent == null)	startcomponent = e.getComponent();
	}
	
	@Override
	public void mousePressed(GSMouseEvent e,SpreadCanvas canvas){
		if (startcomponent != null && (startcomponent != e.getComponent())) return;
		super.mousePressed(e, canvas);
		Region region = canvas.getRegion(e.getPoint());
		new DeleteRegionAction(region).execute();
	}
}
