/* $Id: ChangeBreadthAction.java 327 2011-08-30 12:59:17Z minao $ */
package smart_gs.drawing_tool.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.view.MarkerView;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.Region;
import smart_gs.logical.RegionOperation;
import smart_gs.logical.Spread;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.Pair;

public class ChangeMarkerBreadthAction implements ActionListener {
	private View view;
	private SpreadCanvas canvas;
	private Region region;
	
	public ChangeMarkerBreadthAction(SpreadCanvas canvas, Region region) {
		this.view = region.getView();
		this.canvas = canvas;
		this.region = region;
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		int old_breadth = ((MarkerView)view).getBreadth();
		try {
			String new_breadth_String = JOptionPane.showInputDialog("Please input a positive integer (not less than 5).", old_breadth);
			int new_breadth;
			while (new_breadth_String == null || (new_breadth = Integer.parseInt(new_breadth_String)) < 5) {
				new_breadth_String = JOptionPane.showInputDialog("Please input a positive integer not less than 5.", old_breadth);
			}
			Spread spread = this.canvas.getSpread();
			spread.pushRegionUndoStack(new RegionOperation(RegionOperation.CHANGE_MARKER_BREADTH, region, new Pair<Integer,Integer>(old_breadth,new_breadth),spread));

			((MarkerView)view).setBreadth(Integer.parseInt(new_breadth_String));
			WorkspaceWindow.setUpdated(true);
			ImageLabel.setRectangleVisible(true);
		} catch (NumberFormatException error) {
			JOptionPane.showMessageDialog(canvas.getRootPane(), "An inappropriate value!");
		}
	}

}
