/* $Id: ChangeColorAction.java 1058 2016-01-17 17:09:20Z shayashi $ */
package smart_gs.drawing_tool.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import smart_gs.drawing_tool.view.MarkerView;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.drawing_tool.view.MemoPadView.MemoPadColor;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.Region;
import smart_gs.logical.RegionOperation;
import smart_gs.logical.Spread;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.Pair;

public class ChangeColorAction implements ActionListener {
	View view;
	View.ViewColor color;
	Region region;
	
	public ChangeColorAction(Region region, View.ViewColor color) {
		this.region = region;
		this.view = region.getView();
		this.color = color;
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		if (view instanceof MemoPadView) {
			MemoPadView.ViewColor old_color = ((MemoPadView)view).getViewColor();
			Spread spread = this.region.getSpread();
			spread.pushRegionUndoStack(new RegionOperation(RegionOperation.CHANGE_MEMOPAD_COLOR, region, new Pair<View.ViewColor,View.ViewColor>(old_color,this.color),spread));
			view.setViewColor(this.color);
			WorkspaceWindow.setUpdated(true);
		}
		if (view instanceof MarkerView) {
			MarkerView.ViewColor old_color = ((MarkerView)view).getViewColor();
			Spread spread = this.region.getSpread();
			spread.pushRegionUndoStack(new RegionOperation(RegionOperation.CHANGE_MARKER_COLOR, region, new Pair<View.ViewColor,View.ViewColor>(old_color,this.color),spread));
			view.setViewColor(this.color);
			WorkspaceWindow.setUpdated(true);
		}


	}

}
