/* $Id: ConnectionCreator.java 1072 2016-02-27 04:27:27Z shayashi $ */
/*
 * 作成日: 2006/06/02
 *
 */
package smart_gs.connection;

import java.awt.Frame;
import java.awt.Point;

import javax.swing.JOptionPane;

import reasoning_web.logical.Connection;
import smart_gs.logical.GSResource;
import smart_gs.logical.Preference;
import smart_gs.logical.URICreator;
import smart_gs.logical.URIObject;
import smart_gs.reasoning_web.ExternalLinkDialog;
import smart_gs.reasoning_web.logical.GSConnection;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.ShowLocalViewAction;
import smart_gs.util.HrefChecker;
import sml_editor.swingui.EditorTextPane;


/**
 * @author kazuaki kobayashi
 *
 * 
*/
public class ConnectionCreator {
	
	private static final int NOTHING_HAS_BEEN_SET = 0;
	private static final int SOURCE_HAS_BEEN_SET = 1;
	private static final int TARGET_HAS_BEEN_SET = 2;
	public static final String EXTERNAL_LINK = "external";
	
	private static int makingLink = NOTHING_HAS_BEEN_SET;
	
	public static boolean isMakingLink() {
		return (makingLink == SOURCE_HAS_BEEN_SET || makingLink == TARGET_HAS_BEEN_SET);
	}
	
	public static boolean isMakingLinkSourceAlreadySet() {
		return (makingLink == SOURCE_HAS_BEEN_SET);
	}
	
	public static boolean isMakingLinkTargetAlreadySet() {
		return (makingLink ==  TARGET_HAS_BEEN_SET);
	}
	
	private static void setMakingLink(int makingLink) {
		ConnectionCreator.makingLink = makingLink;
	}
	
	private static GSResource tmpSource = null;

	private static GSResource tmpTarget = null;
	
	private static void ShowLastConnectionToConfirmAndEdit(){
		Connection newestConnection = 
			GS_RWRepository.getInstance().getNewestConnection();
		new lastConnectionToConfirmAndEditFrame(newestConnection,"Created Connection").setVisible(true);
	}

	public static void setSource(GSResource source){
		if (!isMakingLink()) {
			ConnectionCreator.tmpSource = source;
			WorkspaceWindow.getInstance().setStatusBarSource(source.getURI());
			setMakingLink(SOURCE_HAS_BEEN_SET);
			return;
		}
		if (isMakingLinkTargetAlreadySet()){
			if(tmpTarget == null){
				int answer = JOptionPane.showConfirmDialog(new Frame(), "Bug!: link target doesn't exist","Information",JOptionPane.DEFAULT_OPTION);
				if (answer == JOptionPane.OK_OPTION) {
				}
				return;
			};
			
			GSExplanatoryNote note = new GSExplanatoryNote("<xml></xml>");

			GS_RWRepository.getInstance().createConnection(source, tmpTarget, note);
			setDefaultNameOfNewestConnection();
			WorkspaceWindow.getInstance().setStatusBarSource(source.getURI());
//			Show the declared one to check and edit the title and the exp. note.
			if(tmpTarget instanceof GSResource){
				ShowLastConnectionToConfirmAndEdit();
			}
			tmpSource = null;
			tmpTarget = null;
			setMakingLink(NOTHING_HAS_BEEN_SET);
			WorkspaceWindow.getInstance().resetStatusBar();
			return;
		}
		if (isMakingLinkSourceAlreadySet()){
			return;		
		}
	}
	
	public static void setTarget(GSResource target){
		if (!isMakingLink()) {
			ConnectionCreator.tmpTarget = target;
			WorkspaceWindow.getInstance().setStatusBarTarget(target.getURI());
			setMakingLink(TARGET_HAS_BEEN_SET);
			return;
		}
		if (isMakingLinkSourceAlreadySet()){
			if(tmpSource == null){
				int answer = JOptionPane.showConfirmDialog(new Frame(), "Bug!: link source doesn't exist","Information",JOptionPane.DEFAULT_OPTION);
				if (answer == JOptionPane.OK_OPTION) {
				}
				return;
			}
			GSExplanatoryNote note = new GSExplanatoryNote("<xml></xml>");
			GS_RWRepository.getInstance().createConnection(tmpSource, target, note);
			setDefaultNameOfNewestConnection();
			WorkspaceWindow.getInstance().setStatusBarTarget(target.getURI());
//			Show the declared one to check and edit the title and the exp. note.
			if(target instanceof GSResource){
				ShowLastConnectionToConfirmAndEdit();
			}
			tmpSource = null;
			tmpTarget = null;
			setMakingLink(NOTHING_HAS_BEEN_SET);
			WorkspaceWindow.getInstance().resetStatusBar();
			return;
		}
		if (isMakingLinkTargetAlreadySet()){
			return;		
		}
	}
	
	public static void cancaelConnectionCreation(){
		tmpSource = null;
		tmpTarget = null;
		setMakingLink(NOTHING_HAS_BEEN_SET);
		WorkspaceWindow.getInstance().resetStatusBar();
		return;
	}
	
	public static void setExternal(GS_RWElement target,EditorTextPane textPane,Point point){
		String urlStr = null;
		String checkURL = textPane.getSelectURLStr(point);
		int checkid = HrefChecker.check(checkURL);
		if(checkid == -1){
			urlStr = checkURL;
		}
		ExternalLinkDialog externalLinkDialog = new ExternalLinkDialog(WorkspaceWindow.getInstance(),urlStr);
		externalLinkDialog.setLocationRelativeTo(null);
		externalLinkDialog.setVisible(true);
		if(!externalLinkDialog.isCancel()){
			String registUrl = externalLinkDialog.getUrl();
			//textPane.changeID(point,registUrl.toLowerCase());
			//2011.01.04 shayashi when URL is all in lowercase,
			// Google books regards it as a machine generated ID
			// and refuses to connect.
			
			//textPane.changeID(point,registUrl);
			textPane.setURL(point, registUrl);
		}
	}
	public static void removeExternal(GS_RWElement target,
			EditorTextPane textPane, Point point) {
		textPane.removeURL(point);
		
	}

	
	public static boolean isSourceSet(){
		return tmpSource != null;
	}
	public static GS_RWElement getSource(){
		return tmpSource;
	}
	public static boolean isTargetSet(){
		return tmpTarget != null;
	}
	public static GS_RWElement getTarget() {
		return tmpTarget;
	}
	private static void setDefaultNameOfNewestConnection(){
		String date = URIObject.getDate();
		String userName = Preference.getInstance().getUserName();
		GS_RWRepository g = GS_RWRepository.getInstance();
		GSConnection x = g.getNewestConnection();
		x.setName(userName + "@" + date);
	}
}
