/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.validation;

import jp.ac.nii.hcp.shared.validation.NumberOf;
import jp.ac.nii.hcp.shared.validation.ValidationAspect;
import jp.ac.nii.hcp.shared.validation.Validator;

class NumberOfAspect
extends ValidationAspect<Number> {
    public Integer min;
    public Integer max;
    public Double rmin;
    public Double rmax;

    public NumberOfAspect(NumberOf annotation) {
        this.min = annotation.min();
        this.max = annotation.max();
        this.rmin = annotation.rmin();
        this.rmax = annotation.rmax();
    }

    @Override
    protected Class<?> getType() {
        return NumberOf.class;
    }

    @Override
    public Class<Number> getTargetType() {
        return Number.class;
    }

    @Override
    public Validator.Result validate(Number arg) {
        int iValue = arg.intValue();
        if (this.min != null && iValue < this.min) {
            return this.ng("min", this.min);
        }
        if (this.max != null && iValue > this.max) {
            return this.ng("max", this.max);
        }
        double dValue = arg.doubleValue();
        if (this.rmin != null && dValue < this.rmin) {
            return this.ng("min", this.rmin);
        }
        if (this.rmax != null && dValue > this.rmax) {
            return this.ng("max", this.rmax);
        }
        return this.ok();
    }
}

