/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.service;

import com.sun.jersey.oauth.signature.OAuthParameters;
import com.sun.jersey.oauth.signature.OAuthRequest;
import com.sun.jersey.oauth.signature.OAuthSecrets;
import com.sun.jersey.oauth.signature.OAuthSignature;
import com.sun.jersey.oauth.signature.OAuthSignatureException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import jp.ac.nii.hcp.shared.model.HCPUser;
import jp.ac.nii.hcp.shared.model.HCPUserGroup;
import jp.ac.nii.hcp.shared.model.OAuthToken;
import jp.ac.nii.hcp.shared.module.TokenProcessor;
import jp.ac.nii.hcp.shared.module.UserProcessor;
import jp.ac.nii.hcp.shared.service.ConnectionService;
import jp.ac.nii.hcp.shared.service.TokenAPI;

public class TokenService
extends ConnectionService
implements TokenAPI {
    private static final String CONSUMER_SECRET = "hcp.consumer.secret";
    private static final int REQ_EXPIRED_SECONDS = 3600;
    private static final int ACC_EXPIRED_SECONDS = 2592000;

    @Override
    public OAuthToken newRequestToken(OAuthRequest request) throws SQLException {
        OAuthParameters params = new OAuthParameters();
        params.readRequest(request);
        if (!this.verifySignature(request, params, CONSUMER_SECRET, null, null)) {
            return this.ng(null);
        }
        OAuthToken token = this.generateRequestToken();
        TokenProcessor processor = this.getProcessor(TokenProcessor.class, new Object[0]);
        processor.saveRequestToken(token);
        return token;
    }

    @Override
    public OAuthToken authorizeToken(String token, String email, String password) throws SQLException {
        UserProcessor userProcessor = this.getProcessor(UserProcessor.class, new Object[0]);
        HCPUser user = userProcessor.authenticate(email, password);
        if (user == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Failed to user authentication (%s, %s).", email, password));
            }
            return this.ng(null);
        }
        TokenProcessor tokenProcessor = this.getProcessor(TokenProcessor.class, new Object[0]);
        String verifier = this.generateVerifier(token);
        return tokenProcessor.authorizeToken(token, verifier, user.sequence);
    }

    @Override
    public OAuthToken newAccessToken(OAuthRequest request) throws SQLException {
        OAuthParameters params = new OAuthParameters();
        params.readRequest(request);
        String requestTokenString = params.getToken();
        TokenProcessor processor = this.getProcessor(TokenProcessor.class, new Object[0]);
        OAuthToken requestToken = processor.getRequestToken(requestTokenString);
        if (requestToken == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Request token '%s' does not exist or is already expired.", requestTokenString));
            }
            return this.ng(null);
        }
        if (!this.verifySignature(request, params, CONSUMER_SECRET, requestToken.secret, requestToken.verifier)) {
            return this.ng(null);
        }
        OAuthToken accessToken = this.generateAccessToken(requestToken.user);
        processor.saveAccessToken(accessToken);
        processor.deleteRequestToken(requestTokenString);
        return accessToken;
    }

    @Override
    public OAuthToken verifyAccessRequest(OAuthRequest request) throws SQLException {
        OAuthParameters params = new OAuthParameters();
        params.readRequest(request);
        String accessTokenString = params.getToken();
        TokenProcessor processor = this.getProcessor(TokenProcessor.class, new Object[0]);
        OAuthToken accessToken = processor.getAccessToken(accessTokenString);
        if (accessToken == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Access token '%s' does not exist or is already expired.", accessTokenString));
            }
            processor.deleteAccessToken(accessTokenString);
            return this.ng(null);
        }
        if (!this.verifySignature(request, params, CONSUMER_SECRET, accessToken.secret, accessToken.verifier)) {
            return this.ng(null);
        }
        return accessToken;
    }

    @Override
    public void disableToken(String token) throws SQLException {
        TokenProcessor processor = this.getProcessor(TokenProcessor.class, new Object[0]);
        processor.deleteAccessToken(token);
    }

    @Override
    public HCPUserGroup changeGroup(OAuthRequest request, String groupId) throws SQLException {
        OAuthParameters params = new OAuthParameters();
        params.readRequest(request);
        String accessToken = params.getToken();
        HCPUserGroup group = new HCPUserGroup(0, groupId, null, null);
        TokenProcessor processor = this.getProcessor(TokenProcessor.class, new Object[0]);
        return processor.changeAccessGroup(accessToken, group);
    }

    private boolean verifySignature(OAuthRequest request, OAuthParameters params, String consumerSecret, String tokenSecret, String verifier) {
        OAuthSecrets secrets;
        block6: {
            String requestVerifier;
            if (verifier != null && !verifier.equals(requestVerifier = (String)params.get((Object)"oauth_verifier"))) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("Received verifier '%s' is different from saved one '%s'.", requestVerifier, verifier));
                }
                return false;
            }
            secrets = new OAuthSecrets();
            secrets.consumerSecret(consumerSecret);
            secrets.tokenSecret(tokenSecret);
            try {
                if (!OAuthSignature.verify((OAuthRequest)request, (OAuthParameters)params, (OAuthSecrets)secrets)) break block6;
                return true;
            }
            catch (OAuthSignatureException e) {
                this.log.debug((Object)"Format of OAuth request is invalid", (Throwable)e);
                return false;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("System charset : %s, Encoding : %s, Slash : %s", Charset.defaultCharset().toString(), System.getProperty("file.encoding"), System.getProperty("org.apache.tomcat.util.buf.UDecoder.ALLOW_ENCODED_SLASH")));
            this.log.debug((Object)String.format("OAuth verification failed : \nConsumer secret : %s\nToken secret : %s\n%s", secrets.getConsumerSecret(), secrets.getTokenSecret(), params.toString()));
        }
        return false;
    }

    private static String newRandomString() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private OAuthToken generateRequestToken() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(13, 3600);
        String token = TokenService.newRandomString();
        String secret = TokenService.newRandomString();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Generated request token and secret : %s, %s", token, secret));
        }
        return new OAuthToken(token, secret, null, cal.getTime(), null, null);
    }

    private OAuthToken generateAccessToken(HCPUser user) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(13, 2592000);
        String token = TokenService.newRandomString();
        String secret = TokenService.newRandomString();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Generated access token and secret : %s, %s", token, secret));
        }
        return new OAuthToken(token, secret, null, cal.getTime(), user, null);
    }

    private String generateVerifier(String token) {
        String verifier = TokenService.newRandomString();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Generated verifier : %s", verifier));
        }
        return verifier;
    }
}

