/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.module;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import jp.ac.nii.hcp.shared.model.HCPUser;
import jp.ac.nii.hcp.shared.model.HCPUserGroup;
import jp.ac.nii.hcp.shared.model.OAuthToken;
import jp.ac.nii.hcp.shared.module.BaseProcessor;

public class TokenProcessor
extends BaseProcessor {
    public TokenProcessor(Connection db) {
        super(db);
    }

    public void saveRequestToken(OAuthToken token) throws SQLException {
        this.saveRequestToken(token.token, token.secret, token.expired);
    }

    public void saveAccessToken(OAuthToken token) throws SQLException {
        this.saveAccessToken(token.token, token.secret, token.expired, token.user.sequence);
    }

    public void saveRequestToken(String token, String secret, Date expired) throws SQLException {
        String sql = "INSERT INTO req_token (token, secret, expired) VALUES (?, ?, ?)";
        this.doUpdate(sql, token, secret, expired);
    }

    public void saveAccessToken(String token, String secret, Date expired, int userSeq) throws SQLException {
        String sql = "INSERT INTO acc_token (token, secret, expired, user_seq) VALUES (?, ?, ?, ?)";
        this.doUpdate(sql, token, secret, expired, userSeq);
    }

    public OAuthToken authorizeToken(String token, String verifier, int userSeq) throws SQLException {
        String sql = "UPDATE req_token SET verifier = ?, user_seq = ? WHERE token = ?";
        this.doUpdate(sql, verifier, userSeq, token);
        return this.getRequestToken(token);
    }

    public void deleteRequestToken(String token) throws SQLException {
        String sql = "DELETE FROM req_token WHERE token = ?";
        this.doUpdate(sql, token);
    }

    public OAuthToken getRequestToken(String token) throws SQLException {
        String sql = "SELECT * FROM req_token WHERE token = ? AND (expired > ? OR expired IS NULL)";
        ResultSet rs = this.doQuery(sql, token, new Date());
        if (rs.next()) {
            return new OAuthToken(token, rs.getString("secret"), rs.getString("verifier"), rs.getTimestamp("expired"), new HCPUser(rs.getInt("user_seq"), null, null, null, null, null, null), null);
        }
        return null;
    }

    public OAuthToken getAccessToken(String token) throws SQLException {
        String sql = "SELECT at.token, at.secret, at.expired, at.user_seq, u.id AS user_id, u.email, u.last_name, u.first_name, u.organization, u.post, at.group_seq, ug.id AS group_id, ug.name, ug.description FROM acc_token AS at INNER JOIN user AS u ON at.user_seq = u.sequence LEFT JOIN user_group AS ug ON at.group_seq = ug.sequence WHERE at.token = ? AND (at.expired > ? OR at.expired IS NULL) AND u.disabled = 0";
        ResultSet rs = this.doQuery(sql, token, new Date());
        if (rs.next()) {
            HCPUser user = new HCPUser(rs.getInt("user_seq"), rs.getString("user_id"), rs.getString("email"), rs.getString("last_name"), rs.getString("first_name"), rs.getString("organization"), rs.getString("post"));
            int groupSeq = rs.getInt("group_seq");
            HCPUserGroup group = null;
            if (groupSeq > 0) {
                group = new HCPUserGroup(groupSeq, rs.getString("group_id"), rs.getString("name"), rs.getString("description"));
            }
            return new OAuthToken(rs.getString(1), rs.getString("secret"), null, rs.getTimestamp("expired"), user, group);
        }
        return null;
    }

    public void deleteAccessToken(String token) throws SQLException {
        String sql = "DELETE FROM acc_token WHERE token = ?";
        this.doUpdate(sql, token);
    }

    public void deleteUserToken(int userSeq) throws SQLException {
        this.doUpdate("DELETE FROM acc_token WHERE user_seq = ?", userSeq);
    }

    public void deleteExpiredToken(Date now) throws SQLException {
        this.doUpdate("DELETE FROM req_token WHERE expired < ?", now);
        this.doUpdate("DELETE FROM acc_token WHERE expired < ?", now);
    }

    public HCPUserGroup changeAccessGroup(String token, HCPUserGroup group) throws SQLException {
        String sql = "SELECT ug.* FROM acc_token AS at INNER JOIN user AS u ON at.user_seq = u.sequence INNER JOIN r_user_group AS rug ON u.sequence = rug.user_seq INNER JOIN user_group AS ug ON rug.group_seq = ug.sequence WHERE at.token = ? AND ug.id = ? AND (at.expired > ? OR at.expired IS NULL)";
        ResultSet rs = this.doQuery(sql, token, group.id, new Date());
        if (rs.next()) {
            HCPUserGroup newGroup = new HCPUserGroup(rs.getInt("sequence"), rs.getString("id"), rs.getString("name"), rs.getString("description"));
            sql = "UPDATE acc_token SET group_seq = ? WHERE token = ?";
            this.doUpdate(sql, newGroup.sequence, token);
            return newGroup;
        }
        return null;
    }
}

