/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.module;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MutualMap<K, V> {
    private Class<K> keyType = null;
    private Class<V> valueType = null;
    private Map<K, KeyNode<K, V>> keyView = null;
    private Map<V, Map<ItemNode<V, K>, Object>> valueView = null;
    private Map<String, Map<ItemNode<String, K>, Object>> labelView = null;

    public MutualMap(Class<K> keyType, Class<V> valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.keyView = new LinkedHashMap<K, KeyNode<K, V>>();
        this.valueView = new HashMap<V, Map<ItemNode<V, K>, Object>>();
        this.labelView = new HashMap<String, Map<ItemNode<String, K>, Object>>();
    }

    public MutualMap(Class<K> keyType, Class<V> valueType, Object[] ... data) {
        this(keyType, valueType);
        int i = 0;
        while (i < data.length) {
            K key = this.keyType.cast(data[i][0]);
            V value = this.valueType.cast(data[i][1]);
            String label = (String)data[i][2];
            this.put(key, value, label);
            ++i;
        }
    }

    public Class<?> getKeyType() {
        return this.keyType;
    }

    public Class<?> getValueType() {
        return this.valueType;
    }

    public void put(K key, V value, String label) {
        if (this.keyView.containsKey(key)) {
            KeyNode<K, V> kn = this.keyView.get(key);
            this.valueView.get(kn.valueNode.item).remove(kn.valueNode);
            this.labelView.get(kn.labelNode.item).remove(kn.labelNode);
            kn.set(key, value, label);
            this.setNodes(value, label, kn.valueNode, kn.labelNode);
        } else {
            KeyNode<K, V> kn = new KeyNode<K, V>(key, value, label);
            this.keyView.put(key, kn);
            this.setNodes(value, label, kn.valueNode, kn.labelNode);
        }
    }

    private void setNodes(V value, String label, ItemNode<V, K> valueNode, ItemNode<String, K> labelNode) {
        if (!this.valueView.containsKey(value)) {
            this.valueView.put(value, new LinkedHashMap());
        }
        this.valueView.get(value).put(valueNode, null);
        if (!this.labelView.containsKey(label)) {
            this.labelView.put(label, new LinkedHashMap());
        }
        this.labelView.get(label).put(labelNode, null);
    }

    public V getValue(K key) {
        return this.keyView.containsKey(key) ? (V)this.keyView.get(key).valueNode.item : null;
    }

    public String getLabel(K key) {
        return this.keyView.containsKey(key) ? (String)this.keyView.get(key).labelNode.item : null;
    }

    public K findValue(V value) {
        Map<ItemNode<V, K>, Object> values;
        if (this.valueView.containsKey(value) && (values = this.valueView.get(value)).size() > 0) {
            return values.keySet().iterator().next().parent.key;
        }
        return null;
    }

    public K findLabel(String label) {
        Map<ItemNode<String, K>, Object> labels;
        if (this.labelView.containsKey(label) && (labels = this.labelView.get(label)).size() > 0) {
            return labels.keySet().iterator().next().parent.key;
        }
        return null;
    }

    public List<K> searchValue(V value) {
        Map<ItemNode<V, K>, Object> values;
        if (this.valueView.containsKey(value) && (values = this.valueView.get(value)).size() > 0) {
            ArrayList keys = new ArrayList();
            Iterator<ItemNode<V, K>> nodes = values.keySet().iterator();
            while (nodes.hasNext()) {
                keys.add(nodes.next().parent.key);
            }
            return keys;
        }
        return null;
    }

    public List<K> searchLabel(String label) {
        Map<ItemNode<String, K>, Object> labels;
        if (this.labelView.containsKey(label) && (labels = this.labelView.get(label)).size() > 0) {
            ArrayList keys = new ArrayList();
            Iterator<ItemNode<String, K>> nodes = labels.keySet().iterator();
            while (nodes.hasNext()) {
                keys.add(nodes.next().parent.key);
            }
            return keys;
        }
        return null;
    }

    public int size() {
        return this.keyView.size();
    }

    public K getDefault() {
        return this.keyView.keySet().iterator().next();
    }

    public Iterator<K> keyIterator() {
        return this.keyView.keySet().iterator();
    }

    public Iterator<Map.Entry<K, String>> labelIterator() {
        return new LabelIterator(this);
    }

    private static class ItemNode<T, K> {
        public T item = null;
        public KeyNode<K, ?> parent = null;

        protected ItemNode(T item, KeyNode<K, ?> parent) {
            this.item = item;
            this.parent = parent;
        }

        protected void set(T item) {
            this.item = item;
        }
    }

    private static class KeyNode<K, V> {
        public K key = null;
        public ItemNode<V, K> valueNode = null;
        public ItemNode<String, K> labelNode = null;

        protected KeyNode(K key, V value, String label) {
            this.key = key;
            this.valueNode = new ItemNode(value, this);
            this.labelNode = new ItemNode(label, this);
        }

        protected void set(K key, V value, String label) {
            this.key = key;
            this.valueNode.set(value);
            this.labelNode.set(label);
        }
    }

    private static class LabelIterator<K>
    implements Iterator<Map.Entry<K, String>> {
        private MutualMap<K, ?> map = null;
        private Iterator<K> it = null;

        public LabelIterator(MutualMap<K, ?> map) {
            this.map = map;
            this.it = ((MutualMap)map).keyView.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Map.Entry<K, String> next() {
            K key = this.it.next();
            String label = this.map.getLabel(key);
            return new AbstractMap.SimpleEntry<K, String>(key, label);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

