/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.model;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jp.ac.nii.hcp.shared.model.HCPAttachment;
import jp.ac.nii.hcp.shared.model.HCPDocument;
import jp.ac.nii.hcp.shared.model.HCPImage;
import jp.ac.nii.hcp.shared.model.HCPMaterial;
import jp.ac.nii.hcp.shared.model.HCPProject;
import jp.ac.nii.hcp.shared.model.HCPProjectHistory;
import jp.ac.nii.hcp.shared.model.HCPProjectMember;
import jp.ac.nii.hcp.shared.model.HCPUser;
import jp.ac.nii.hcp.shared.model.HCPUserGroup;
import org.w3c.dom.Element;

@XmlRootElement(name="hcp")
public class HCPMixedWrapper {
    @XmlAttribute
    public final String version = "1.0";
    @XmlTransient
    private Map<Class<?>, List<Object>> index = null;
    @XmlMixed
    @XmlElementRefs(value={@XmlElementRef(name="project", type=HCPProject.class), @XmlElementRef(name="material", type=HCPMaterial.class), @XmlElementRef(name="document", type=HCPDocument.class), @XmlElementRef(name="attachment", type=HCPAttachment.class), @XmlElementRef(name="history", type=HCPProjectHistory.class), @XmlElementRef(name="user", type=HCPUser.class), @XmlElementRef(name="group", type=HCPUserGroup.class), @XmlElementRef(name="member", type=HCPProjectMember.class), @XmlElementRef(name="image", type=HCPImage.class)})
    public List<Object> hcpElements = new ArrayList<Object>();

    public HCPMixedWrapper add(Object element) {
        this.hcpElements.add(element);
        return this;
    }

    public <T> T getHCPElement(Class<T> type) {
        if (this.index == null) {
            this.createIndex();
        }
        if (HCPProject.class.isAssignableFrom(type) || HCPMaterial.class.isAssignableFrom(type) || HCPDocument.class.isAssignableFrom(type) || HCPAttachment.class.isAssignableFrom(type) || HCPProjectHistory.class.isAssignableFrom(type) || HCPUser.class.isAssignableFrom(type) || HCPUserGroup.class.isAssignableFrom(type) || HCPProjectMember.class.isAssignableFrom(type) || HCPImage.class.isAssignableFrom(type)) {
            return this.getIndexedValue(type);
        }
        return null;
    }

    public <T> List<T> getHCPElements(Class<T> type) {
        if (this.index == null) {
            this.createIndex();
        }
        if (HCPProject.class.isAssignableFrom(type) || HCPMaterial.class.isAssignableFrom(type) || HCPDocument.class.isAssignableFrom(type) || HCPAttachment.class.isAssignableFrom(type) || HCPProjectHistory.class.isAssignableFrom(type) || HCPUser.class.isAssignableFrom(type) || HCPUserGroup.class.isAssignableFrom(type) || HCPProjectMember.class.isAssignableFrom(type) || HCPImage.class.isAssignableFrom(type)) {
            List<Object> values = this.index.get(type);
            AbstractList elements = new AbstractList<T>(values){
                public List<Object> innerList;
                {
                    this.innerList = list;
                }

                @Override
                public T get(int index) {
                    return this.innerList.get(index);
                }

                @Override
                public int size() {
                    return this.innerList.size();
                }
            };
            return elements;
        }
        return null;
    }

    private <T> T getIndexedValue(Class<T> type) {
        List<Object> values = this.index.get(type);
        if (values != null && values.size() > 0) {
            return type.cast(values.get(0));
        }
        return null;
    }

    private void createIndex() {
        this.index = new HashMap();
        this.index.put(HCPProject.class, new ArrayList());
        this.index.put(HCPMaterial.class, new ArrayList());
        this.index.put(HCPDocument.class, new ArrayList());
        this.index.put(HCPAttachment.class, new ArrayList());
        this.index.put(HCPProjectHistory.class, new ArrayList());
        this.index.put(HCPUser.class, new ArrayList());
        this.index.put(HCPUserGroup.class, new ArrayList());
        this.index.put(HCPProjectMember.class, new ArrayList());
        this.index.put(HCPImage.class, new ArrayList());
        for (Object element : this.hcpElements) {
            if (element instanceof String || element instanceof Element) continue;
            if (element instanceof HCPProject) {
                this.index.get(HCPProject.class).add(element);
                continue;
            }
            if (element instanceof HCPMaterial) {
                this.index.get(HCPMaterial.class).add(element);
                continue;
            }
            if (element instanceof HCPDocument) {
                this.index.get(HCPDocument.class).add(element);
                continue;
            }
            if (element instanceof HCPAttachment) {
                this.index.get(HCPAttachment.class).add(element);
                continue;
            }
            if (element instanceof HCPProjectHistory) {
                this.index.get(HCPProjectHistory.class).add(element);
                continue;
            }
            if (element instanceof HCPUser) {
                this.index.get(HCPUser.class).add(element);
                continue;
            }
            if (element instanceof HCPUserGroup) {
                this.index.get(HCPUserGroup.class).add(element);
                continue;
            }
            if (element instanceof HCPProjectMember) {
                this.index.get(HCPProjectMember.class).add(element);
                continue;
            }
            if (!(element instanceof HCPImage)) continue;
            this.index.get(HCPImage.class).add(element);
        }
    }
}

