/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.model;

import java.util.Date;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="image")
public class HCPImage {
    private static final Integer OWNER_CODE_MAX_LENGTH = 16;
    private static final Integer IMAGE_CODE_MAX_LENGTH = 16;
    private static final String IMAGE_CODE_PATTERN = "^[0-9a-zA-Z\\-_]+$";
    public String owner_code;
    public String image_code;
    public OwnerType owner_type;
    public String url;
    public Date created;

    public HCPImage() {
        this.owner_code = null;
        this.image_code = null;
        this.owner_type = null;
        this.url = null;
        this.created = null;
    }

    public HCPImage(String owner_code, String image_code, OwnerType owner_type, String url, Date created) {
        this.owner_code = owner_code;
        this.image_code = image_code;
        this.owner_type = owner_type;
        this.url = url;
        this.created = created;
    }

    public String getPath() {
        return "/" + this.owner_code + "/" + this.image_code;
    }

    public boolean validateRegistration() {
        boolean valid;
        boolean bl = valid = this.owner_code != null && this.owner_code.length() > 0 && this.owner_code.length() <= OWNER_CODE_MAX_LENGTH && this.owner_type != null && this.url != null && this.url.length() > 0;
        if (this.image_code != null) {
            valid = valid && this.image_code.length() > 0 && this.image_code.length() <= IMAGE_CODE_MAX_LENGTH && this.image_code.matches(IMAGE_CODE_PATTERN);
        }
        return valid;
    }

    public String toString() {
        String out = "OwnerCode :" + this.owner_code + "\n" + "ImageCode :" + this.image_code + "\n" + "OwnerType :" + this.owner_type.toString() + "\n" + "URL : " + this.url;
        return out;
    }

    @XmlEnum
    public static enum OwnerType {
        USER,
        GROUP;

    }
}

