/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.jersey.ext.provider;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import jp.ac.nii.hcp.shared.model.OAuthToken;

@Provider
public class OAuthTokenBodyReader
implements MessageBodyReader<OAuthToken> {
    private static final String TOKEN_KEY = "oauth_token=";
    private static final String SECRET_KEY = "oauth_token_secret=";
    private static final String VERIFIER_KEY = "oauth_verifier=";

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isAssignableFrom(OAuthToken.class);
    }

    public OAuthToken readFrom(Class<OAuthToken> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String kv;
        BufferedReader reader = new BufferedReader(new InputStreamReader(entityStream));
        String data = reader.readLine();
        reader.close();
        int offset = 0;
        int index = data.indexOf("&");
        OAuthToken token = new OAuthToken();
        while (index > 0) {
            kv = data.substring(offset, index);
            this.setupTokenValue(kv, token);
            offset = index + 1;
            index = data.indexOf("&", offset);
        }
        kv = data.substring(offset);
        this.setupTokenValue(kv, token);
        return token;
    }

    private void setupTokenValue(String kv, OAuthToken token) {
        if (kv.startsWith(TOKEN_KEY)) {
            token.token = kv.substring(TOKEN_KEY.length());
        } else if (kv.startsWith(SECRET_KEY)) {
            token.secret = kv.substring(SECRET_KEY.length());
        } else if (kv.startsWith(VERIFIER_KEY)) {
            token.verifier = kv.substring(VERIFIER_KEY.length());
        }
    }
}

