/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.net;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import javax.ws.rs.core.MediaType;
import jp.ac.nii.hcp.client.shared.ClientConfiguration;
import jp.ac.nii.hcp.shared.model.HCPElementWrapper;
import jp.ac.nii.hcp.shared.model.HCPImage;
import jp.ac.nii.hcp.shared.model.HCPImageList;

public class ImageClient {
    private Client client = Client.create();
    private ClientConfiguration config;

    public ImageClient(ClientConfiguration config) {
        this.config = config;
    }

    public HCPImageList search(String id, Integer page, Integer limit) throws IOException {
        String url = this.config.imageServerURL().append(id).toUrl();
        WebResource resource = this.client.resource(url);
        if (page != null) {
            resource = resource.queryParam("page", page.toString());
        }
        if (limit != null) {
            resource = resource.queryParam("limit", limit.toString());
        }
        try {
            return (HCPImageList)resource.accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(HCPImageList.class);
        }
        catch (UniformInterfaceException e) {
            return new HCPImageList();
        }
    }

    public HCPImage fetch(String imagePath) throws IOException {
        String path = imagePath.charAt(0) == '/' ? imagePath.substring(1) : imagePath;
        String url = this.config.imageServerURL().append(path).toUrl();
        WebResource resource = this.client.resource(url);
        try {
            HCPElementWrapper image = (HCPElementWrapper)resource.accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(HCPElementWrapper.class);
            return (HCPImage)image.element;
        }
        catch (UniformInterfaceException e) {
            return null;
        }
    }

    public void add(HCPImage image) throws IOException {
        String url = this.config.imageServerURL().toUrl();
        WebResource resource = this.client.resource(url);
        resource.type(MediaType.APPLICATION_XML_TYPE).post((Object)new HCPElementWrapper((Object)image));
    }
}

