/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import jp.ac.nii.hcp.client.cli.CommandTemplate;
import jp.ac.nii.hcp.client.cli.UndefinedCommandException;

class CommandSelector {
    private Set<CommandTemplate> commands = new HashSet<CommandTemplate>();
    private static final String HELP_COMMAND_NAME = "help";
    private static CommandTemplate helpCommand = new CommandTemplate(new String[]{"help"}){

        public void execute(CommandSelector selector) {
            StringBuffer buf = new StringBuffer();
            ArrayList<String> lines = new ArrayList<String>();
            for (CommandTemplate command : selector.commands) {
                Class<?>[] paramTypes;
                String[] commands;
                String[] stringArray = commands = command.getCommands();
                int n = commands.length;
                int n2 = 0;
                while (n2 < n) {
                    String c = stringArray[n2];
                    buf.append(c).append(" ");
                    ++n2;
                }
                Class<?>[] classArray = paramTypes = command.getParamTypes();
                int n3 = paramTypes.length;
                n = 0;
                while (n < n3) {
                    Class<?> type = classArray[n];
                    buf.append(type.getSimpleName()).append(" ");
                    ++n;
                }
                lines.add(buf.toString());
                buf.delete(0, buf.length());
            }
            Object[] helpLines = lines.toArray(new String[0]);
            Arrays.sort(helpLines);
            Object[] objectArray = helpLines;
            int n = helpLines.length;
            int n4 = 0;
            while (n4 < n) {
                Object line = objectArray[n4];
                System.out.println((String)line);
                ++n4;
            }
        }
    };

    public CommandSelector(CommandTemplate ... commands) {
        CommandTemplate[] commandTemplateArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            CommandTemplate command = commandTemplateArray[n2];
            this.commands.add(command);
            ++n2;
        }
    }

    public void enableHelp() {
        if (!this.commands.contains(helpCommand)) {
            this.commands.add(helpCommand);
        }
    }

    public void disableHelp() {
        this.commands.remove(helpCommand);
    }

    public void inject(Injector injector) {
        for (CommandTemplate command : this.commands) {
            command.inject(injector);
        }
    }

    public Object invoke(String commandLine) throws UndefinedCommandException, Throwable {
        String[] commandArgs = commandLine.split("\\s+");
        for (CommandTemplate command : this.commands) {
            Object[] args = null;
            args = command == helpCommand ? command.accept(commandArgs, this) : command.accept(commandArgs, new Object[0]);
            if (args == null) continue;
            if (command == helpCommand) {
                return command.invoke(new Object[]{this});
            }
            return command.invoke(args);
        }
        throw new UndefinedCommandException(String.format("%s is not interpreted as a command.", commandLine));
    }

    public static interface Injector {
    }
}

