#!/bin/ksh
set -e
cd -- "$(dirname -- "${0}")/../../.."

if [ -z "${cc_path}" ]; then
	cc_path="/usr/local/bin/egcc"
fi

mk_slunk() {
	gmake -B CC="${cc_path}" MARCH=${2} MTUNE=${3} STATIC=1 STRIP=1
	cp -vf "frontend/bin/slunkcrypt" "out/slunkcrypt-${1}"
}

rm -rf "out" && mkdir -p "out"

gmake CC="${cc_path}" clean

case "$(uname -m)" in
	amd64)
		mk_slunk "x86_64" "x86-64" "nocona"
		;;
	i386)
		mk_slunk "i686" "pentiumpro" "pentium3"
		;;
	*)
		echo "Unknown host CPU type !!!"
		exit 1
esac

echo "Build completed successfully."
