#!/bin/zsh
set -e
cd -- "$(dirname -- "${(%):-%N}")/../../.."

if [ -z "${cc_path}" ]; then
	cc_path="/usr/bin/cc"
fi

mk_slunk() {
	make -B CC="${cc_path}" TARGET="${1}-apple-darwin" FLTO=1
	strip -o "out/slunkcrypt-${1}" "frontend/bin/slunkcrypt"
}

rm -rf "out" && mkdir -p "out"

make CC="${cc_path}" clean

mk_slunk "x86_64"
mk_slunk "arm64"

echo "Build completed successfully."
