#!/bin/bash
set -e
cd -- "$(dirname -- "${BASH_SOURCE[0]}")/../../.."

mk_slunk() {
	make -B CC=${1} MARCH=${3} MTUNE=${4} STATIC=1 STRIP=1
	cp -vf "frontend/bin/slunkcrypt" "out/slunkcrypt-${2}"
}

rm -rf "out" && mkdir -p "out"

make clean

case "${BE_HOST_CPU}" in
	x86_64)
		mk_slunk "gcc" "x86_64" "x86-64" "nocona"
		;;
	x86)
		mk_slunk "gcc-x86" "i686" "pentiumpro" "pentium3"
		;;
	*)
		echo "Unknown host CPU type !!!"
		exit 1
esac

echo "Build completed successfully."
