#!/bin/bash
# See "etc/utils/linux/mk-musl.sh" in order to build musl libc!
set -e
cd -- "$(dirname -- "${BASH_SOURCE[0]}")"

function mk_slunk() {
	local command="make -B CC=/usr/local/musl/${1}-linux-gnu/bin/musl-gcc STATIC=1 STRIP=1 FLTO=1"
	if [ ! -z "${2}" ]; then
		command="${command} ${2}"
	fi
	$BASH -x -c "${command}"
	cp -vf "frontend/bin/slunkcrypt" "out/slunkcrypt-${1}"
}

rm -rf "out" && mkdir -p "out"

$BASH -x -c "make clean"

mk_slunk "x86_64" "MARCH=x86-64 MTUNE=nocona"
mk_slunk "i686" "MARCH=pentiumpro MTUNE=generic"
mk_slunk "aarch64"

printf "\033[1;32m\nBuild completed successfully.\033[0m\n\n"
