#!/bin/bash
cd -- "$(dirname -- "${BASH_SOURCE[0]}")"

rm -rf "enc" "out"
mkdir -p "bin" "org" "enc" "out"

readonly PASSWD="T25na1i{XYuUMFDi2fRqk258"

for file in org/*; do
	name="$(basename -- "$file")"
	
	# Encrypt -A-
	echo -e "\n\033[1;36m---===[ ${name} ]===---\033[0m\n"
	if ! ${BASH} -x -c "bin/slunkcrypt-a -e \"pass:${PASSWD}\" \"${file}\" \"enc/${name}~~A\""; then
		echo -e "\n\033[1;31mError: File could not be encoded !!!\033[0m"
		exit 1
	fi

	# Encrypt -B-
	if ! ${BASH} -x -c "bin/slunkcrypt-b -e \"pass:${PASSWD}\" \"${file}\" \"enc/${name}~~B\""; then
		echo -e "\n\033[1;31mError: File could not be encoded !!!\033[0m"
		exit 1
	fi
	
	# Print hash
	sha256sum "enc/${name}~~A" "enc/${name}~~B" && echo ""

	# Decrypt -A/B-
	if ! ${BASH} -x -c "bin/slunkcrypt-a -d \"pass:${PASSWD}\" \"enc/${name}~~B\" \"out/${name}~~A\""; then
		echo -e "\n\033[1;31mError: File could not be decoded !!!\033[0m"
		exit 1
	fi
	if ! cmp "out/${name}~~A" "${file}"; then
		echo -e "\n\033[1;31mError: Decoded file does *not* match original !!!\033[0m"
		exit 1
	fi
	
	# Decrypt -B/A-
	if ! ${BASH} -x -c "bin/slunkcrypt-b -d \"pass:${PASSWD}\" \"enc/${name}~~A\" \"out/${name}~~B\""; then
		echo -e "\n\033[1;31mError: File could not be decoded !!!\033[0m"
		exit
	fi
	if ! cmp "out/${name}~~A" "out/${name}~~B"; then
		echo -e "\n\033[1;31mError: Decoded files are *not* the same !!!\033[0m"
		exit 1
	fi
	
	# Print hash
	sha256sum "out/${name}~~A" "out/${name}~~B" && echo ""
done

echo -e "\n\033[1;32mAll tests have completed successfully!\033[0m"
