<?php

function plugin_br(){
  return "<br/>";
}

function plugin_hr(){
  return "<hr/>";
}

function plugin_clear(){
  return "<br clear=\"all\"/>";
}

function plugin_news($n){
  global $_SIWIKI;

  $db = OpenDB($_SIWIKI['dbname'],$_SIWIKI['wiki_dir']);
  $str = "<div id=\"news\">";
  $str .= getNews($db, $_SIWIKI['category']."/".$_SIWIKI['pagename'], $_SESSION['lang'],  $_SIWIKI['page'], $n,'', false);
  $str .= "</div> <!-- news-->\n";
  $db->close();
         
  return $str;
}


function plugin_comment($lvl){
  global $_SIWIKI;

  ChkVal($comment_cmd, "comment_cmd", "");
  ChkVal($oid, "oid", -1);
  ChkVal2($info, "info", "");
  ChkVal2($uid, "uid", "guest");

  $path =  $_SIWIKI['wiki_dir']."/documents/".$_SIWIKI['category']."/".$_SIWIKI['pagename'];
  $num=0;

  if(!$lvl) $lvl=SITE_ADMIN;
  else $lvl = str2level($lvl);
  $user_level=get_user_level();

  $db=OpenCommentDB();

  if($comment_cmd == "input" && $info){
   if($oid>0){
     updateCommentData($db, $oid, $uid, $info, $_SERVER['REMOTE_ADDR'],$_SESSION['lang']);
   }else{
     insertCommentData($db, $uid, $info, $_SERVER['REMOTE_ADDR'],$_SESSION['lang']);
   }
  }else if($comment_cmd == "delete"){
   deleteCommentData($db, $oid, $uid, $_SERVER['REMOTE_ADDR'],$_SESSION['lang']);
  }

  $data = getCommentData($db, $_SESSION['lang']);
  $db->close();
  if($data){ $num=$data->num; }


  $thisPageName=$_SIWIKI['pagename'];
  $str = "====\n";

  for($i=0;$i<$data->num ;$i++){
    $vals = $data->fetchArray($i);
    $id = $vals['rowid'];
    if(($comment_cmd=='edit' && $oid==$id) && ($user_level>=$lvl || $vals['ipaddr'] == $_SERVER['REMOTE_ADDR'])){
      $comment_line=$vals['info'];
      $comment_name=$vals['name'];
      $comment_id=$id;
    }
  
    if($user_level>=$lvl || $vals['ipaddr'] == $_SERVER['REMOTE_ADDR']){
      $str .= "-".ltrim($vals['info'])."[[*>$thisPageName.html&comment_cmd=edit&oid=$id]]    ---&size(9){".$vals['name']." ".$vals['mdate']."};~\n";
    }else{
      $str .= "-".ltrim($vals['info'])."    ---&size(9){".$vals['name']." ".$vals['mdate']."};~\n";
    }
  }

  $wikistr = siwiki($str);

  $thisPage = getCurrentPage();
   $wikistr .=<<<_HTML
  <form action="$thisPage" method="POST">
COMMENT: <input type="text" name="uid" value="$comment_name" size="10">
  <input type="text" name="info" value="$comment_line" size="50">
  <input type="hidden" name="oid" value="$comment_id" size="50">
  <input type="submit" name="comment_cmd" value="input">
  <input type="submit" name="comment_cmd" value="delete">
  </form>
_HTML;

 return $wikistr;
}

function plugin_include_html($fname){
  $filename=WikiDir('attachments')."/$fname";
	
  if(file_exists($filename)){
    $str = file_get_contents($filename);
  }else{
    $str = "<blockquote><br>".$fname."</br> not found. <br> Please upload the file.</blockquote>";
  }

  return $str;
}

function plugin_getWikiName2($x){
 return getWikiName2($x);
}

function plugin_attachall(){
  $fnames=get_attached_files();
  $i=1;
  $str = "<hr><font color=\"green\">資料</font><p><font size=\"2\"><ul>";
  foreach($fnames as $fname){
    $ref_file = mkReferenceUrl($fname,"attachments");
    $str .= "<li><b>添付資料$i</b>：";
    $str .= "<a href=\"$ref_file/download\" >$fname</a>";
    if(get_user_level() > AVARAGE_USER)
      $str .= " &nbsp; <a href=\"$ref_file/delete_file\" >[DEL]</a></li>";
    $i++;
  }
  if($i==1) $str .= "<b>添付資料なし</b>";
  $str .= "</ul>";
  return $str;
}

function plugin_attach($fname, $refname=""){
  $ref_file = mkReferenceUrl($fname,"attachments");
  $str = "<p>添付ファイル：";
  if($refname) $str .= "<a href=\"$ref_file/download\" >$refname</a>";
  else $str .= "<a href=\"$ref_file/download\" >$fname</a>";

  if(get_user_level() > AVARAGE_USER)
    $str .= " &nbsp; <a href=\"$ref_file/delete_file\" >[DEL]</a>";

  return $str;
}

function plugin_html_tag($tag, $klass="")
{
  if($klass != "") 
  {
    $str = "<".$tag." class='".$klass."'>";
  }else{
    $str = "<".$tag.">";
  }
  return $str;
}

function plugin_indent($n = -1)
{
  if($n > 0){
    $str = '<div  style="padding-left:'.$n.'em">';
  }else{
    $str = "</div>";
  }
  return $str;
}

function plugin_member_only($lvl=GUEST_USER)
{
  global $member_only;

  $check_user=get_user_level($_SESSION['uid']);

  if($check_user <= $lvl){
    $member_only = true;
  }
}

function plugin_site_only($ipaddr="127.0.0.1", $netmask = 24)
{
  global $site_only;

  if($site_only == 0){
     $site_only = 2;
  }
  $ip_long = ip2long($ipaddr) >> (32 - $netmask);
  $remote = ip2long($_SERVER["REMOTE_ADDR"]) >> (32 - $netmask);

  if($ip_long == $remote)
  {
    $site_only = 1;
  }
}

?>
