<?php

ChkVal($cmd,'cmd','');
ChkVal($lang,'lang',$_SESSION['lang']);
ChkVal($pagename,'pagename',$_SIWIKI['pagename']);
ChkVal($histpage,"histpage",""); 

$title = "Page Histroy Viewer";
$content .= "<h2>Log View</h2>";
$content .= "<h4>".getWikiName2($pagename)."</h4>";

list($dir, $files) = historyfilelist($category, $pagename, $lang);
$dir=WikiDir('documents', $category, $pagename);
$histdir = $dir."/hist_".$lang;

$histview = "";
$histfile .= $histdir."/".$histpage;
$pagefilename = $dir."/content.".$lang.".txt";

if($cmd == "show"){
  $str = file_get_contents($histfile);
  $histview .= "<div id=\"wiki\">";
  $histview .= $histpage;
  $histview .= "<hr>";
  $histview .= siwiki($str);
  $histview .= "</div>";

}else if($cmd == "replace"){
  copy($histfile, $pagefilename);
  $histview .= " Copy ";
  $histview .= basename($histfile);
  $histview .= " to ";
  $histview .= basename($pagefilename);


}else if($cmd == "del"){
  if(file_exists($histfile)) unlink($histfile);

  $histview .= "<ul>";
  foreach($files as $ff){
    if($ff != $histpage){
      $page = getStaticPage($lang, $category, $pagename, 'history');
      $histview .= "<li><a href=\"$page&cmd=show&pagename=$pagename&histpage=$ff\">".$ff."</a></li>";
    }
  }
  $histview .= "</ul>";

}else {
  $histview .= "<ul>";
  foreach($files as $ff){
    $page = getStaticPage($lang, $category, $pagename, 'history');
    $histview .= "<li><a href=\"$page&cmd=show&pagename=$pagename&histpage=$ff\">".$ff."</a></li>";
  }
  $histview .= "</ul>";
}

if($lang == "en") $en = " selected ";
else  $ja = " selected ";

$categories =  getCategoryList();
$pages = pagelist($category, $lang);

$content .=<<<_HTML
<form action="$thisFile" method="post">
<select name="lang">
<option value="ja" $ja>ja
<option value="en" $en>en
</select>
<select name="category">
_HTML;


foreach($categories as $x){
 if($category == $x) $content .= "<option value=\"$x\" selected> $x";
 else $content .= "<option value=\"$x\"> $x";
}

$content .=<<<_HTML
</select>
<select name="pagename">
_HTML;

foreach($pages as $x){
 if($pagename == $x) $content .= "<option value=\"$x\" selected>".getWikiName2($x);
 else $content .= "<option value=\"$x\">".getWikiName2($x);
}

$content .=<<<_HTML
</select>

<input type="hidden" name="histpage" value="$histpage">
<input type="submit" name="cmd" value="list">
<input type="submit" name="cmd" value="del">
<input type="submit" name="cmd" value="replace">
<input type="hidden" name="sub" value="history">
</form>
<hr>
_HTML;

$content .= $histview;

?>

