<?php

require_once('Smarty.class.php');
require_once('simg-functions.php');
require_once('SimgLog.php');

/**
 * ---------------------------------------------------
 * 関数命名規約
 * -----------------------+---------------------------
 * function_[plugin-name] | テンプレート関数プラグイン
 * block_[plugin-name]    | ブロック関数プラグイン
 * compiler_[plugin-name] | コンパイラ関数プラグイン
 * modifier_[plugin-name] | 修飾子プラグイン
 * -----------------------+---------------------------
 */

/**
 * Type: function
 * Name: ss_url
 * Purpose: URL作成
 */
function function_url($params, &$smarty) {
	$queries = array();
	$wq = simg_get_array_value($params, SS_PARAM_QUERY, null);
	if($wq != null && strlen($wq) > 0) {
		parse_str($wq, $queries);
	}
	//SimgLog::getInstance()->put(PEAR_LOG_DEBUG, "__make_url queries: [%s]", print_r($queries, true));
	$dir = simg_get_array_value($params, SS_PARAM_DIRECTORY, '');
	return simg_make_url($dir, $queries);
}

/**
 * Type: function
 * Name: ss_script
 * Purpose: SCRIPT-URL作成
 */
function function_script($params, &$smarty) {
	$dir = simg_get_array_value($params, SS_PARAM_DIRECTORY, '');
	$path = simg_get_array_value($params, SS_PARAM_PATH, '');
	return simg_make_url(
		$dir,
		array(
			SIMG_PARAM_EVENT => SIMG_EVENT_SCRIPT,
			SIMG_PARAM_SRC => $path
		)
	);
}

/**
 * Type: function
 * Name: ss_json_decode
 * Purpose: JSON文字列デコード
 */
function function_json_decode($params, &$smarty) {
	$v = simg_get_array_value($params, SS_PARAM_VALUE, '');
	$a = simg_get_array_value($params, SS_PARAM_ASSOC, false);
	return json_decode($v, $a);
}

/**
 * Type: function
 * Name: ss_json_encode
 * Purpose: JSON文字列エンコード
 */
function function_json_encode($params, &$smarty) {
	$v = simg_get_array_value($params, SS_PARAM_VALUE, '');
	return json_encode($v);
}

/**
 * Type: function
 * Name: ss_url_encode
 * Purpose: URLエンコード
 */
function function_url_encode($params, &$smarty) {
	$v = simg_get_array_value($params, SS_PARAM_VALUE, '');
	return rawurlencode($v);
}

/**
 * Type: function
 * Name: ss_version
 * Purpose: Simg version
 */
function function_version($params, &$smarty) {
	return sprintf('Simg version %d.%d.%d', 2, 0, 30);
}

?>
