<?php

require_once('simg-functions.php');
require_once('SimgException.php');
require_once('SimgLog.php');

/**
 * SimgDB基底クラス
 * @author System Concept
 *
 */
abstract class SimgDb {

	/**
	 * データベースインスタンス
	 */
	protected $db;
	/**
	 * テーブル情報
	 * key: テーブル名
	 * value: 属性配列
	 */
	protected $table;
	/**
	 * Path管理
	 */
	protected $app_path;

	/**
	 * 構築
	 * @param $ap Path管理
	 */
	public function __construct($ap) {
		$this->initialize($ap);
	}
	/**
	 * 初期化処理
	 * @param $ap Path管理
	 */
	protected function initialize($ap) {
		$this->app_path = $ap;
		$this->db = $this->createDb();
		$this->table = $this->createTable();
	}
	/**
	 * DB-configファイルパス取得
	 * @return ファイルパス
	 */
	//protected function getDbConfigPath() {
	//	return simg_combine_path(SIMG_PATH_CONFIG, SIMG_FN_CONFIG_DB);
	//}
	/**
	 * TABLE-configファイルパス取得
	 * @return ファイルパス
	 */
	//protected function getTableConfigPath() {
	//	return simg_combine_path(SIMG_PATH_CONFIG, SIMG_FN_CONFIG_TABLE);
	//}
	/**
	 * DB作成
	 * @return データベースインスタンス
	 */
	protected function createDb() {
		$ap = $this->app_path;
		$db = null;
		$ini = simg_parse_ini_file_pathes($ap->getPathes('getConfigPath'), SIMG_FN_CONFIG_DB);
		if(!is_null($ini)) {
			try {
				$db = new PDO($ini[SIMG_ENTRY_DB_DSN], $ini[SIMG_ENTRY_DB_USER], $ini[SIMG_ENTRY_DB_PASSWORD]);
			} catch (PDOException $e) {
				throw new SimgException('PDO create error.', __FILE__, __LINE__);
			}
		}
		return $db;
	}
	/**
	 * 接頭語付加
	 * @param $pre 接頭語
	 * @param $name 名称
	 * @return string 接頭語付き名称
	 */
	private function makePrefix($pre, $name) {
		if(!is_null($pre)) {
			$name = $pre . $name;
		}
		return $name;
	}
	/**
	 * TABLE作成
	 * @return テーブル情報
	 */
	protected function createTable() {
		$ap = $this->app_path;
		//$maps = simg_make_definemap($this->getTableConfigPath(), array('attribute', 'table:attribute'), array());
		$maps = simg_make_definemap(simg_parse_ini_file_pathes($ap->getPathes('getConfigPath'), SIMG_FN_CONFIG_TABLE, true), array('attribute', 'table:attribute'), array());
		return simg_get_array_value($maps, 'table', null);
	}
	/**
	 * DB取得
	 */
	public function getDb() {
		return $this->db;
	}
}

?>
