<?php

require_once('simg-functions.php');
require_once('SimgLog.php');

/**
 * SimgアプリケーションPath管理クラス
 * @author System Concept
 *
*/
class SimgApplicationPath {

	/**
	 * ルートパス配列
	 */
	protected $roots;

	/**
	 * 構築
	 * @param $app_root ルートパス
	 */
	public function __construct($app_root) {
		if(is_array($app_root)) {
			$this->roots = $app_root;
		} else {
			$this->roots = array($app_root);
		}
	}

	/**
	 * ルートパス配列取得
	 * @return ルートパス配列
	 */
	public function getRoots() {
		return $this->roots;
	}

	/**
	 * 最初に存在するファイルのフルパスを取得する
	 * @param $relative_path 相対パス
	 * @param $fn ファイル名
	 * @return ファイルフルパス
	 */
	public function findFirstExistFile($relative_path, $fn=null) {
		$ret = "";
		foreach($this->roots as $path) {
			$w = simg_combine_path($path, $relative_path);
			if(!is_null($fn)) {
				$w = simg_combine_path($w, $fn);
			}
			if(file_exists($w)) {
				$ret = $w;
				break;
			}
		}
		return $ret;
	}

	/**
	 * パス配列を取得する
	 * @param $method パス取得メソッド名 (ex.'getApplicationPath', 'getConfigPath', 'getControllerPath', etc...)
	 * @return パス配列
	 */
	public function getPathes($method) {
		$ar = array();
		foreach($this->roots as $root) {
			$ar[] = call_user_func(array(get_class($this), $method), $root);
		}
		//SimgLog::getInstance()->put(PEAR_LOG_DEBUG, "getPathes : ar=%s", print_r($ar, true));
		return $ar;
	}

	/**
	 * アプリケーションパスを取得する
	 * @param $root ルートパス
	 * @return パス
	 */
	public static function getApplicationPath($root=null) {
		return is_null($root)? SIMG_DIRECTORY_APPLICATION: simg_combine_path($root, SIMG_DIRECTORY_APPLICATION);
	}
	/**
	 * CONFIGパスを取得する
	 * @param $root ルートパス
	 * @return パス
	 */
	public static function getConfigPath($root=null) {
		return simg_combine_path(self::getApplicationPath($root), SIMG_DIRECTORY_CONFIG);
	}
	/**
	 * コントローラパスを取得する
	 * @param $root ルートパス
	 * @return パス
	 */
	public static function getControllerPath($root=null) {
		return simg_combine_path(self::getApplicationPath($root), SIMG_DIRECTORY_CONTROLLER);
	}
	/**
	 * ポーターパスを取得する
	 * @param $root ルートパス
	 * @return パス
	 */
	public static function getPorterPath($root=null) {
		return simg_combine_path(self::getControllerPath($root), SIMG_DIRECTORY_PORTER);
	}
	/**
	 * アクションパスを取得する
	 * @param $root ルートパス
	 * @return パス
	 */
	public static function getActionPath($root=null) {
		return simg_combine_path(self::getControllerPath($root), SIMG_DIRECTORY_ACTION);
	}
	/**
	 * ページャパスを取得する
	 * @param $root ルートパス
	 * @return パス
	 */
	public static function getPagerPath($root=null) {
		return simg_combine_path(self::getControllerPath($root), SIMG_DIRECTORY_PAGER);
	}
	/**
	 * レンダーパスを取得する
	 * @param $root ルートパス
	 * @return パス
	 */
	public static function getRenderPath($root=null) {
		return simg_combine_path(self::getControllerPath($root), SIMG_DIRECTORY_RENDER);
	}
	/**
	 * オーバーロードパスを取得する
	 * @param $root ルートパス
	 * @return パス
	 */
	public static function getOverloadPath($root=null) {
		return simg_combine_path(self::getControllerPath($root), SIMG_DIRECTORY_OVERLOAD);
	}
	/**
	 * モデルパスを取得する
	 * @param $root ルートパス
	 * @return パス
	 */
	public static function getModelPath($root=null) {
		return simg_combine_path(self::getApplicationPath($root), SIMG_DIRECTORY_MODEL);
	}
	/**
	 * ビューパスを取得する
	 * @param $root ルートパス
	 * @return パス
	 */
	public static function getViewPath($root=null) {
		return simg_combine_path(self::getApplicationPath($root), SIMG_DIRECTORY_VIEW);
	}
	/**
	 * テンプレートパスを取得する
	 * @param $root ルートパス
	 * @return パス
	 */
	public static function getTemplatePath($root=null) {
		return simg_combine_path(self::getViewPath($root), SIMG_DIRECTORY_TEMPLATE);
	}
	/**
	 * テンプレートキャッシュパスを取得する
	 * @param $root ルートパス
	 * @return パス
	 */
	public static function getTemplateCachePath($root=null) {
		return simg_combine_path(self::getViewPath($root), SIMG_DIRECTORY_TEMPLATE_CACHE);
	}
	/**
	 * テンプレートコンパイルパスを取得する
	 * @param $root ルートパス
	 * @return パス
	 */
	public static function getTemplateCompilePath($root=null) {
		return simg_combine_path(self::getViewPath($root), SIMG_DIRECTORY_TEMPLATE_COMPILE);
	}
	/**
	 * リソースパスを取得する
	 * @param $root ルートパス
	 * @return パス
	 */
	public static function getResourcePath($root=null) {
		return simg_combine_path(self::getViewPath($root), SIMG_DIRECTORY_RESOURCE);
	}
	/**
	 * プラグインパスを取得する
	 * @param $root ルートパス
	 * @return パス
	 */
	public static function getPluginPath($root=null) {
		return simg_combine_path(self::getViewPath($root), SIMG_DIRECTORY_PLUGIN);
	}
}

?>
